"""Ocena naszego agenta  przy użyciu testowego zestawu danych.

To rozwiązanie korzysta z LangSmith. Utwórz i usatw swójklucz LangSmith API.
Moduł run_benchmark wykonuje się na zestawie danych.
"""
import os

from langsmith import Client

from config import set_environment

set_environment()
os.environ["LANGCHAIN_TRACING_V2"] = "true"
os.environ["LANGCHAIN_PROJECT"] = "Mój projekt"

client = Client()
questions = [
    "Części statku są stopniowo wymieniane, aż żadne z oryginalnych części nie pozostają. Czy to wciąż ten sam statek? Dlaczego lub dlaczego nie?",
    # Paradoks statku Tezeusza
    "Gdyby ktoś spędził całe życie przykuty w jaskini, widząc jedynie cienie, jak by zareagował, gdyby go uwolniono i pokazano mu prawdziwy świat?",
    # Alegoria jaskini Platona
    "Czy coś jest dobre, ponieważ jest naturalne, czy złe, ponieważ jest nienaturalne? Dlaczego może to być błędny argument?",
    # Błąd odwołania do natury
    "Jeśli moneta zostanie rzucona 8 razy i za każdym razem wypadnie orzeł, jakie są szanse, że następnym razem wypadnie reszka? Wyjaśnij swoje rozumowanie.",
    # Błąd hazardzisty
    "Przedstawienie dwóch opcji jako jedynych, gdy istnieją również inne. Czy stwierdzenie \"Jesteś z nami albo przeciwko nam\" przykład fałszywego dylematu? Dlaczego?",
    # Fałszywy dylemat
    "Czy ludzie mają tendencję do rozwijania preferencji do rzeczy tylko dlatego, że są z nimi zaznajomieni? Czy ma to wpływ na rozumowanie?",
    # Efekt czystej ekspozycji
    "Czy jest zaskakujące, że wszechświat jest odpowiedni dla inteligentnego życia, skoro gdyby nie był, nikt nie byłby w stanie go obserwować?",
    # Zasada antropiczna
    "Jeśli statek Tezeusza zostaje odrestaurowany poprzez wymianę każdej deski, czy nadal jest tym samym statkiem? Na czym opiera się tożsamość?",
    # Paradoks  Tezeusza
    "Jeśli statek Tezeusza zostanie odrestaurowany przez wymianę każdej deski, czy nadal jest tym samym statkiem? Na czym opiera się tożsamość?",
    # Błąd równi pochyłej
    "Czy twierdzenie jest prawdziwe, ponieważ nie zostało udowodnione jako fałszywe? Dlaczego mogłoby to utrudniać rozumowanie?",  # Appeal to Ignorance
]

shared_dataset_name = "Rozumowanie i tendencyjność"
# Uwtorzenie zestawu danych na LangSmith:
ds = client.create_dataset(
    dataset_name=shared_dataset_name, description="Kilka pytań z zakresu rozumowania i skrzywienia poznawczego",
)
for q in questions:
    client.create_example(inputs={"input": q}, dataset_id=ds.id)

if __name__ == "__main__":
    pass
