"""Oblizanie liczb pierwszych.

Ten fragment kodu został wygenerowany przez Starcoder.
"""


def calculate_primes(n):
    # Utwórz listę kolejnych liczb całkowitych od 2 do n.
    candidates = [True] * (n + 1)

    # Ustaw dwa pierwsze elementy tej listy na False, gdyż nie są liczbami pierwszymi.
    candidates[0] = candidates[1] = False

    for i in range(2, int(n ** 0.5) + 1):
        if candidates[i]:
            # Oznacz wszystkie wielokrotności i jako liczby niebędące pierwszymi.
            for j in range(i * i, n + 1, i):
                candidates[j] = False

    return [x for x in range(2, n + 1) if candidates[x]]


if __name__ == "__main__":
    # Dodane z palca.
    print(eratosthenes_sieve(20))
    # Zwrócone wyniki: [2, 3, 5, 7, 11, 13, 17, 19]
