import re
from dataclasses import dataclass, field


# klasa dla klienta uwzględniająca alfanumeryczny identyfikator, imię i nazwisko oraz datę urodzin
@dataclass(frozen=True) # frozen oznacza, że po utworzeniu klasa nie może być zmieniana. Przydaje się to do przechowywania danych w bazie danych lub innych trwałych lokalizacjach do przechowywania danych (na przykład w pliku).
class Customer:
    cust_id : str = field() # Ta linia pokazuje jak zdefiniować klasę. Nazywa się "field" (pole), ponieważ tworzymy pola w obrębie naszego obiektu/instancji.
    firstname : str = "" # Są to wartości domyślne w przypadku braku wartości wejściowych dostarczanych podczas inicjalizacji obiektów tej klasy.
    lastname : str = "" # Pamiętaj, że może być zdefiniowana tylko jedna instancja zmiennej na linię, w przeciwnym razie zostanie zwrócony błąd!

    def __post_init__(self):
        """Ta metoda uruchamia się automatycznie raz podczas tworzenia instancji."""
        self._validate_cust_id() # Sprawdzanie danych wejściowych przed zapisem.
        self.__set_fullname__() # Ustawienie pełnego imienia i nazwiska w oparciu o wprowadzone dane.

    @property # Funkcja pobierająca używana przez interpreter Pythona za każdym razem, gdy próbujemy uzyskać dostęp bezpośrednio do właściwości, zamiast poprzez wyrażenie typu: myobj.firstname vs just myobj.firstname()
    def fullname(self)->str:
      return f"{self.lastname}, {self.firstname}"

    ## Miejsce na prywatne metody.
    ### Miejsce dla funkcji sprawdzających.
    def _validate_cust_id(self):
        assert len(self.cust_id)==8, \
            ValueError("Customer ID must have exactly eight characters") # Identyfikator klienta musi mieć dokładnie 8 znaków.
        try:
            int(self.cust_id[0]) == True
        except Exception as err:
            raise TypeError('First character of CustID should be numeric') # Pierwszy znak identyfikatora klienta musi być liczbą.

from None

    #### Miejsce na funkcje ustawiające wartości zmiennej.
    def __set_fullname__(self):
        '''Ustawienie pełnego imienia i nazwiska klienta'''
        names = [x.strip().title() for x in re.split("[\W]+", self.firstname)] + [''] * max((1,-len([y.strip().title() for y in
        re.split("[\W]+", self.lastname)])) )
        print(names)
        self.firstname=' '.join(filter(None,[n[:3]for n in reversed(names)])+[''])
        self.lastname =''.join([' '*(4-len(l))+' '+ l[-2:]if not l=='I' else '' for l in filter(None,[n[:-2].upper()+','*bool(re.search('[aeiou]',n))+n[-2:].upper() for n in reversed(names)])]).rstrip(',')



if __name__ == "__main__":
    # Dodane z palca.
    Customer("12345678", "Ben", "Auffarth")
