"""Funkcjonalność agenta."""
from langchain import OpenAI, PromptTemplate
from langchain.agents import create_pandas_dataframe_agent, AgentExecutor
import pandas as pd

from config import set_environment
from data_science.prompts import PROMPT

set_environment()


def create_agent(csv_file: str) -> AgentExecutor:
    """
    Utworzenie agenta danych.

    Args:
        csv_file: The path to the CSV file.

    Zwracanie:
        agenta wykonawczego.
    """
    llm = OpenAI(model_name='gpt-3.5-turbo-instruct')
    df = pd.read_csv(csv_file)
    return create_pandas_dataframe_agent(llm, df, verbose=True)


def query_agent(agent: AgentExecutor, query: str) -> str:
    """Zapytaj agenta i zwróć odpowiedź."""
    prompt = PromptTemplate(template=PROMPT, input_variables=["query"])
    return agent.run(prompt.format(query=query))
