/*
Rapid Prototyping with JS to książka o JavaScripcie i Node.js, dzięki której dowiesz się, jak można szybciej tworzyć aplikacje internetowe. — Więcej informacji o tej książce znajdziesz w witrynie:
http://rapidprototypingwithjs.com.
*/
const mongodb = require('mongodb')
const url = require('url')
const log = console.log
const dbUri = process.env.MONGOHQ_URL || 'mongodb://localhost:27017/test'

const connectionUri = url.parse(dbUri)
const dbName = connectionUri.pathname.replace(/^\//, '')

mongodb.Db.connect(dbUri, function(error, client) {
  if (error) throw error

  client.collectionNames(function(error, names){
    if(error) throw error

    // Wyświetlenie nazw wszystkich kolekcji.
    log("Kolekcje")
    log("===========")
    let lastCollection = null
    names.forEach(function(colData){
      var colName = colData.name.replace(dbName + ".", '')
      log(colName)
      lastCollection = colName
    })
    if (!lastCollection) return
    const collection = new mongodb.Collection(client, lastCollection)
    log("\nDokumenty w " + lastCollection)
    const documents = collection.find({}, {limit:5})

    // Wyświetlenie liczby znalezionych dokumentów.
    documents.count((error, count) => {
      log(" Znaleziono " + count + " dokumentów.")
      log("====================")

      // Wyświetlenie pierwszych pięciu dokumentów.
      documents.toArray((error, docs) => {
        if(error) throw error

        docs.forEach((doc) => {
          log(doc)
        })
     
        // Zamknięcie połączenia.
        client.close()
      })
    })
  })
})
