const util = require('util')
const url = require('url')
const http = require('http')
const mongodb = require ('mongodb')
const client = require ('mongodb').MongoClient

const port = process.env.PORT || 1337
const dbConnUrl = process.env.MONGOLAB_URI || 'mongodb://@127.0.0.1:27017/test'

client.connect(dbConnUrl, {}, (error, db) => {
  console.log('Błąd: ', error)
  db.listCollections().toArray((error, collections) => {
    console.log('Błąd: ', error)
    console.log('Kolekcje: ', collections)
    const server = http.createServer( (request, response) => { // Utworzenie serwera.
      response.writeHead(200, {'Content-Type': 'text/plain'})   // Zdefiniowanie odpowiedniego nagłówka i kodu stanu.
      response.end(util.inspect(collections))  // Wygenerowanie ciągu tekstowego ze znakiem nowego wiersza.
    })
    server.listen(port, () => {
      console.log('Serwer jest dostępny pod adresem %s:%s ',
        server.address().address, server.address().port) // Zdefiniowanie adresu IP serwera i numeru portu.
    })
    db.close()
  })
})
