/**
 * Przykład dla statycznych elementów klasy
 */
class Person {
  static String personLabel = "Person name:";

  String firstName;
  String lastName;

  String get fullName => "$personLabel $firstName $lastName";
  
  Person(this.firstName, this.lastName);

  static void printsPerson(Person person) {
    print("$personLabel ${person.firstName} ${person.lastName}");
  }
}

main() {
  Person somePerson = Person("clark", "kent");
  Person anotherPerson  = Person("peter", "parker");

  print(somePerson.fullName); // wyświetla: clark kent
  print(anotherPerson.fullName); // wyświetla: peter parker

  Person.personLabel = "name:";

  print(somePerson.fullName); // wyświetla: clark kent
  print(anotherPerson.fullName); // wyświetla: peter park

  Person.printsPerson(somePerson); // wyświetla: clark kent
  Person.printsPerson(anotherPerson); // wyświetla: peter park
}
