# Flutter dla początkujących

<a href="https://www.packtpub.com/mobile/flutter-for-beginners?utm_source=github&utm_medium=repository&utm_campaign=9781788996082"><img src="https://www.packtpub.com/media/catalog/product/cache/e4d64343b1bc593f1c5348fe05efa4a6/9/7/9781788996082-original.jpeg" alt="Flutter for Beginners" height="256px" align="right"></a>

To jest repozytorium kodu [Flutter dla początkujących](https://www.packtpub.com/mobile/flutter-for-beginners?utm_source=github&utm_medium=repository&utm_campaign=9781788996082), opublikowanego przez Packt.

**Przewodnik po tworzeniu wieloplatformowych aplikacji mobilnych za pomocą Fluttera i Darta 2**

## O czym jest ta książka?
Google Flutter to wieloplatformowa platforma mobilna, która ułatwia pisanie bezpiecznych i wydajnych aplikacji natywnych dla systemów iOS i Android.

Ta książka obejmuje następujące ekscytujące funkcje:
* Poznaj podstawy języka programowania Dart
* Poznaj podstawowe koncepcje interfejsu użytkownika Flutter i sposób jego kompilacji dla wielu platform
* Opracuj wtyczki i widżety Fluttera i zrozum, jak zbudować dobry kod wtyczki
* Stylizuj swoje aplikacje za pomocą widżetów i poznaj różnicę między widżetami stanowymi i bezstanowymi
* Dodaj animację do swojego interfejsu użytkownika za pomocą komponentu AnimatedBuilder firmy Flutter
* Zintegruj swój kod natywny z bazą kodu Flutter, aby uzyskać wydajność aplikacji natywnej

Jeśli uważasz, że ta książka jest dla Ciebie, zdobądź [kopię](https://www.amazon.com/dp/1788996089) już dziś!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" alt="https://www.packtpub.com/" border="5" /></a>

## Instrukcje i nawigacja
Cały kod jest zorganizowany w foldery. Na przykład rozdział02.

Kod będzie wyglądał następująco:
```
main() {
  var yeahDartIsGreat = "Obviously!";
  var dartIsGreat = yeahDartIsGreat ?? "I don't know";
  print(dartIsGreat); // wyświetla Obviously!
}
```

**Potrzebujesz następujących informacji:**
Ta książka jest przeznaczona dla programistów, którzy chcą nauczyć się od podstaw rewolucyjnej platformy firmy Google, Flutter. Nie jest wymagana znajomość Fluttera lub Darta. Pomocna będzie jednak podstawowa znajomość języka programowania.

Za pomocą poniższej listy oprogramowania i sprzętu możesz uruchomić wszystkie pliki kodu znajdujące się w książce (rozdział 1-15).

### Lista oprogramowania i sprzętu

| Rozdział | Wymagane oprogramowanie             | Wymagany system operacyjny         |
| -------- | ------------------------------------| -----------------------------------|
| 1-3      | Javascript-enabled web browser      | Windows, Mac OS X, and Linux (Any) |
| 4-15     | Flutter SDK                         | Windows, Mac OS X, and Linux (Any) |
| 9 i 13   | XCode                               | Mac OS X                           |

Udostępniamy również plik PDF z kolorowymi obrazami zrzutów ekranu/diagramów użytych w tej książce. [Kliknij tutaj, aby go pobrać](https://static.packt-cdn.com/downloads/9781788996082_ColorImages.pdf).

### Produkty powiązane
* React Native Cookbook – Wydanie drugie [[Packt]](https://www.packtpub.com/application-development/react-native-cookbook-second-edition?utm_source=github&utm_medium=repository&utm_campaign=9781788991926) [[Amazon]] (https://www.amazon.com/dp/1788991923)

* Projekty Xamarin. Forms [[Packt]](https://www.packtpub.com/application-development/xamarinforms-projects?utm_source=github&utm_medium=repository&utm_campaign=9781789537505) [[Amazon]](https://www.amazon .com/dp/1789537509)

## Poznaj autora

**Alessandro Biessek** urodził się w 1993 roku w pięknym mieście Chapecó w stanie Santa Catarina w południowej Brazylii. Obecnie pracuje nad rozwojem aplikacji mobilnych na Androida i iOS w swoim rodzinnym mieście. Ma ponad 7-letnie doświadczenie w programowaniu, od programowania desktopów w Delphi po backend w PHP, Node.js, Golang, programowanie mobilne z Apache Flex i Java/Kotlin. Większość czasu poświęca na tworzenie aplikacji na Androida. Zawsze zainteresowany nowymi technologiami, od dłuższego czasu podąża za frameworkiem Flutter.

### Sugestie i opinie
[Kliknij tutaj](https://docs.google.com/forms/d/e/1FAIpQLSdy7dATC6QmEL81FIUuymZ0Wy9vH1jHkvpY57OiMeKGqib_Ow/viewform), jeśli masz jakieś uwagi lub sugestie.
