﻿package  
{
	import flash.display.MovieClip;
	import flash.events.*;
	import flash.net.URLVariables;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.text.TextField;
	
	public class Poll extends MovieClip 
	{
		public var POLL_ID:uint = 1;
		public var phpFile:String = "http://localhost/helion/r13/Poll/poll.php";
		public var container:MovieClip;
		public var pollItems:Array;
		public function Poll() 
		{
			pollItems = new Array();
			container = new MovieClip();
			container.x = 15;
			container.y = 100;
						
			addChild(container);
			
			loadPollData();
		}
		
		public function loadPollData():void
		{
			var urlVariables:URLVariables = new URLVariables;
			urlVariables.a = "getpolldata";
			urlVariables.id = POLL_ID;
			
			var urlRequest:URLRequest = new URLRequest(phpFile);
			urlRequest.data = urlVariables;
			
			var urlLoader:URLLoader = new URLLoader();
			urlLoader.addEventListener(Event.COMPLETE, dataLoaded);
			urlLoader.load(urlRequest);
		}

		public function dataLoaded(e:Event):void
		{
			var urlLoader:URLLoader = URLLoader(e.target);
			var xml:XML = new XML(urlLoader.data);
			
			for each(var item in xml..element)
			{
				var type:String = item..attribute('type');
				var value:String = item..attribute('value');
				var total:uint = uint(xml..attribute('total'));
				
				if(type == "question")
				{
					this['questionTxt'].text = value;
					continue;
				}
				
				if(type == "answer")
				{
					var votes:uint = uint(item..attribute('votes'));
				}
				
				var pollItem:PollItem = new PollItem();
				pollItem['percentTxt'].text = Math.round(votes / total * 100) + "%";
				pollItem['barMC'].width = (votes / total * 100) * 4;
				pollItem.y = (pollItems.length * (pollItem.height + 20));
				
				container.addChild(pollItem);
				pollItems.push(pollItem);
			}
		}
	}
}
