var phpPath:String 			= "http://localhost/flashphp/examples/ch%2011/chatClient/";
var phpSendMessage:String	= phpPath + "message.php";
var phpLoadMessages:String	= phpPath + "getMessages.php";

var loadingMessages:Boolean	= false;
var sendingMessage:Boolean	= false;
var chatMessages:Array		= new Array();

var timer:Timer;
var usersOnline:uint;

function init():void
{
	// start timer for loading of messages
	timer = new Timer(5000, 0);
	timer.addEventListener(TimerEvent.TIMER, timerHandler);
	timer.start();
	
	usersOnline = 1;
	usersOnlineTxt.text = usersOnline + " users online";
	
	loadMessages(); // first time
}

function sendMessage(e:MouseEvent):void
{
	if(usernameTxt.text == "")
	{
		trace("Username required");
		return;
	}
	
	if(newMsgTxt.text.length >= 3)
	{
		var variables:URLVariables = new URLVariables();
		variables.user = usernameTxt.text;
		variables.msg = newMsgTxt.text;

		var urlRequest:URLRequest = new URLRequest(phpSendMessage);
		urlRequest.method = URLRequestMethod.POST;
		urlRequest.data = variables;
		
		var urlLoader:URLLoader = new URLLoader();
		urlLoader.addEventListener(Event.COMPLETE, sendMessageHandler);
		urlLoader.load(urlRequest);
	}
}

function sendMessageHandler(e:Event):void
{
	var loader:URLLoader = URLLoader(e.target);
	var variables:URLVariables = new URLVariables(loader.data);
	trace("Response: " + variables.resp);
}

function loadMessages():void
{
	if(loadingMessages) return;
	loadingMessages  = true;
	
	var urlRequest:URLRequest = new URLRequest(phpSendMessage);
	var urlLoader:URLLoader = new URLLoader();
	
	urlLoader.addEventListener(Event.COMPLETE, loadMessagesHandler);
	urlLoader.load(urlRequest);
}

function loadMessagesHandler(e:Event):void
{
	var loader:URLLoader = URLLoader(e.target);
	var variables:URLVariables = new URLVariables(loader.data);
	loadingMessages = false;
	
	trace("Messages: " + variables.resp);
}

function timerHandler(e:TimerEvent):void
{
	trace("Timer hit");
	loadMessages();
}

sendBtn.addEventListener(MouseEvent.CLICK, sendMessage);

init();