package
{
	import flash.display.MovieClip;
	import flash.text.TextField;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	public class VideoListItem extends MovieClip
	{

		public var videoObj:Object;

		private var _id:uint;
		private var _title:String;
		private var _desc:String;
		private var _thumb:String;
		private var _src:String;
		
		public static const ITEM_CLICK:String = "onItemClick";
		
		function VideoListItem() 
		{
			alpha = 0.5;
		}
		
		function setItem(id:uint, thumb:String, src:String)
		{
			_id = id;
			_thumb = thumb;
			_src = src;
			
			buttonMode = true;
			useHandCursor = true;
			addEventListener(MouseEvent.ROLL_OVER, overHandler);
			addEventListener(MouseEvent.ROLL_OUT, outHandler);
			addEventListener(MouseEvent.CLICK, clickHandler);
		}
		
		private function overHandler(e:MouseEvent):void
		{
			e.currentTarget.alpha = 1.0;
		}
				
		private function outHandler(e:MouseEvent):void
		{
			e.currentTarget.alpha = 0.5;
		}
				
		private function clickHandler(e:MouseEvent):void
		{
			dispatchEvent(new Event(ITEM_CLICK));
		}
		
		public function get id():uint
		{
			return _id;
		}
		
		public function get source():String
		{
			return _src;
		}

		public function get title():String
		{
			return _title;
		}
		public function set title(val:String):void
		{
			_title = val;
			titleTxt.text = val;
		}
		
		public function get desc():String
		{
			return _desc;
		}
		public function set desc(val:String):void
		{
			_desc = val;
			descTxt.text = val;
		}

	}
}