package 
{
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Vector3D;
	import flash.ui.Keyboard;
	
	import away3d.containers.ObjectContainer3D;
	import away3d.containers.View3D;
	import away3d.loaders.Loader3D;
	import away3d.loaders.Max3DS;
	
	import com.greensock.TweenMax;
	
	public class KeyboardEventsExample extends Sprite 
	{
		[Embed(source="../../resources/swfs/Monitor.swf")]
		private var SpeedMonitor:Class;
		
		private var view:View3D;
		private var speed:Number = 5;
		private var shipLoader:Loader3D;
		private var ship:ObjectContainer3D;
		private var leftArrowDown:Boolean = false;
		private var rightArrowDown:Boolean = false;
		private var upArrowDown:Boolean = false;
		private var downArrowDown:Boolean = false;
		private var spaceDown:Boolean = false;	
		private var trackShip:Boolean = false;
		private var speedMonitor:Sprite;
		
		public function KeyboardEventsExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			//
			view = new View3D();
			view.x = 320;
			view.y = 240;
			addChild(view);
			view.camera.z = -100;
			//
			//speedMonitor = new SpeedMonitor();
			//speedMonitor.txt.text = String(speed * 10);
			//addChild(speedMonitor);
			//
			loadShipModel();
			onResize();
		}
		
		private function onResize(e:Event = null):void
		{
			universe.x = stage.stageWidth * .5;
			universe.y = stage.stageHeight * .5;
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
			speedMonitor.y = stage.stageHeight - 100;
			speedMonitor.x = 100;
		}
		
		private function loadShipModel():void
		{
			ship = new ObjectContainer3D();
			shipLoader = Max3DS.load('../../resources/models/max3ds/spaceship/spaceship.3DS');
			shipLoader.rotationY = -90;
			shipLoader.rotationX = 90;
			shipLoader.position = new Vector3D(0, 0, 0);
			ship.addChild(shipLoader);
			view.scene.addChild(ship);
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			if (e.keyCode == Keyboard.C) 
			{
				speed = 5;
				//speedMonitor.txt.text = String(speed * 10);
			}
			if (e.keyCode == Keyboard.A) 
			{
				speed += .5;
				//speedMonitor.txt.text = String(speed * 10);
			}
			if (e.keyCode == Keyboard.Z) 
			{
				speed -= .5;
				//speedMonitor.txt.text = String(speed * 10);
			}
			if (e.keyCode == Keyboard.LEFT)  leftArrowDown = true;
			if (e.keyCode == Keyboard.RIGHT) rightArrowDown = true;
			if (e.keyCode == Keyboard.UP)    upArrowDown = true;
			if (e.keyCode == Keyboard.DOWN)  downArrowDown = true
			if (e.keyCode == Keyboard.SPACE) spaceDown = true;
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			if (e.keyCode == Keyboard.LEFT)  leftArrowDown = false;
			if (e.keyCode == Keyboard.RIGHT) rightArrowDown = false;
			if (e.keyCode == Keyboard.UP)    upArrowDown = false;
			if (e.keyCode == Keyboard.DOWN)  downArrowDown = false
			if (e.keyCode == Keyboard.SPACE) spaceDown = false;
			if (e.keyCode == Keyboard.X)
			{
				trackShip = false;
				view.camera.lookAt(new Vector3D(0, 0, 0));
				TweenMax.to(ship, 1, { x:0, y:0, z:0, rotationY:0, rotationX:0, rotationZ:0 } );
			}
			if (e.keyCode == Keyboard.T)
			{
				trackShip = !trackShip;
			}
		}
		
		private function onEnterFrame(e:Event):void
		{
			if (spaceDown)      ship.moveForward(speed);
			if (leftArrowDown)  ship.roll(-5);
			if (rightArrowDown) ship.roll(5);
			if (upArrowDown)    ship.pitch(5);
			if (downArrowDown)  ship.pitch( -5);
			
			if (trackShip) view.camera.lookAt(ship.scenePosition);
			view.render();
		}
	}
}