package  
{
	import away3d.containers.View3D;
	import away3d.core.base.Mesh;
	import away3d.sprites.Sprite3D;
	import away3d.sprites.MovieClipSprite;
	import away3d.sprites.DirectionalSprite;
	import away3d.materials.BitmapFileMaterial;
	import away3d.primitives.GridPlane;
	import away3d.core.base.Vertex;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	
	public class spritesExample extends Sprite
	{
		private var view:View3D;
		private var hero:Mesh;
		
		public function spritesExample() 
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			view = new View3D();
			view.camera.position = new Vector3D(0, 600, -1000);
			view.camera.lookAt(new Vector3D(0, 0, 0));
			addChild(view);
			
			var grid:GridPlane = new GridPlane( { width:1000, height:1000, segmentsH:10, segmentsW:10 } );
			view.scene.addChild(grid);
			
			onResize();
			initSprite3DObjects();
			initMovieClipSpriteObjects();
			initDirectionalSpriteObject();
			stage.addEventListener(Event.RESIZE, onResize);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function initSprite3DObjects():void
		{
			var s3d:Sprite3D = new Sprite3D(new BitmapFileMaterial('../../resources/sprites/doom/monster.png'), 91, 74);
			var monster1:Mesh = new Mesh( { x: -300, z:300 } );
			monster1.addSprite(s3d);
			var monster2:Mesh = monster1.clone() as Mesh;
			monster2.x = 300;
			var monster3:Mesh = monster2.clone() as Mesh;
			monster3.z = -300;
			var monster4:Mesh = monster3.clone() as Mesh;
			monster4.x = -300;
			view.scene.addChild(monster1);
			view.scene.addChild(monster2);
			view.scene.addChild(monster3);
			view.scene.addChild(monster4);
		}
		
		private function initMovieClipSpriteObjects():void
		{
			var monster1:Mesh = new Mesh( { z:300 } );
			monster1.addSprite(new MovieClipSprite(new Monster()));
			var monster2:Mesh = new Mesh( { z: -300 } );
			monster2.addSprite(new MovieClipSprite(new Monster()));
			var monster3:Mesh = new Mesh( { x:300 } );
			monster3.addSprite(new MovieClipSprite(new Monster()));
			var monster4:Mesh = new Mesh( { x: -300 } );
			monster4.addSprite(new MovieClipSprite(new Monster()));
			view.scene.addChild(monster1);
			view.scene.addChild(monster2);
			view.scene.addChild(monster3);
			view.scene.addChild(monster4);
		}
		
		private function initDirectionalSpriteObject():void
		{
			hero = new Mesh();
			view.scene.addChild(hero);
			var ds:DirectionalSprite = new DirectionalSprite(null, 210, 216);
			ds.addDirectionalMaterial(new Vertex(0, 0, -1),    new BitmapFileMaterial('../../resources/sprites/duke/f.png'));
			ds.addDirectionalMaterial(new Vertex(0, 0, 1),   new BitmapFileMaterial('../../resources/sprites/duke/b.png'));
			ds.addDirectionalMaterial(new Vertex(1, 0, 0),    new BitmapFileMaterial('../../resources/sprites/duke/r.png'));
			ds.addDirectionalMaterial(new Vertex( -1, 0, 0),  new BitmapFileMaterial('../../resources/sprites/duke/l.png'));
			ds.addDirectionalMaterial(new Vertex( -.75, 0, -.75),  new BitmapFileMaterial('../../resources/sprites/duke/fl.png'));
			ds.addDirectionalMaterial(new Vertex(.75, 0, -.75),    new BitmapFileMaterial('../../resources/sprites/duke/fr.png'));
			ds.addDirectionalMaterial(new Vertex( -.75, 0, .75), new BitmapFileMaterial('../../resources/sprites/duke/bl.png'));
			ds.addDirectionalMaterial(new Vertex(.75, 0, .75),   new BitmapFileMaterial('../../resources/sprites/duke/br.png'));
			hero.addSprite(ds);			
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
		}
		
		private function onEnterFrame(e:Event):void
		{
			hero.rotationY++;
			view.render();
		}
	}
}