-------------------------------------------------------------------------------------
-- AS3GeometryClassExporter.ms
-- This utility exports geometry from Max 3.0 & > to AS3 classes 
-- Author Seraf aka Jerome Birembaut  -  www.not-so-stupid.com
-- PV3D 2.0 support by mr.doob - www.mrdoob.com
-------------------------------------------------------------------------------------

rollout AS3GeomClassExporter "AS3GeomExporter"
(
	-- Definition des variables
	local ostream,
	awayLite= "Away3DLite 1.0",
	away= "Away3D",
	sandy="Sandy 3.0",
	papervision="Papervision3D 1.5",
	papervision2="Papervision3D 2.0",
	engineName  = #(awayLite,away,sandy,papervision,papervision2),







awayLiteHeaderFormat = "package %
{
import away3dlite.arcane;
import away3dlite.materials.Material;
import away3dlite.primitives.AbstractPrimitive;
public class % extends AbstractPrimitive{
use namespace arcane;
protected function v(x : Number, y : Number, z : Number) : void {_vertices.push(x, -y, z);}
protected function uv(u : Number, v : Number) : void {_uvtData.push(u,-v,1);}		
protected function f(a : int, b : int, c : int) : void {
_indices.push(a,b,c);
_faceLengths.push(3);
}
public function %(material:Material = null){
super(material);
type = '%';
url = 'primitive';
}
protected override function buildPrimitive():void
{
super.buildPrimitive();",
awayLiteVertexFormat = "v(%,%,%);\n",
awayLiteUVFormat ="uv(%,%);\n",
awayLiteFaceFormat ="f(%,%,%);\n",
awayLiteFooterFormat ="}
}
}",
awayHeaderFormat = "package %
{
import away3d.arcane; 
import away3d.core.base.*; 
public class % extends Mesh{
use namespace arcane;
private var varr:Array;
private var uvarr:Array;
private function v(x:Number,y:Number,z:Number):void{varr.push(new Vertex(x,y,z));}
private function uv(u:Number,v:Number):void{uvarr.push(new UV(u,v));}
private function f(vn0:int, vn1:int, vn2:int, uvn0:int, uvn1:int, uvn2:int):void{addFace(new Face(varr[vn0],varr[vn1],varr[vn2], null, uvarr[uvn0],uvarr[uvn1],uvarr[uvn2]));}
public function %(init:Object = null)
{
super(init);
varr = [];
uvarr = [];
build();
}
private function build():void
{\n",
awayVertexFormat = "v(%,%,%);\n",
awayUVFormat ="uv(%,%);\n",
awayFaceFormat ="f(%,%,%, %,%,%);\n",
awayFooterFormat ="}
}
}",

papervisionHeaderFormat = "package %
{
import org.papervision3d.core.*;
import org.papervision3d.core.proto.*;
import org.papervision3d.core.geom.*;

import flash.display.BitmapData;
public class % extends Mesh3D
{\npublic var verts :Array;
public var faceAr:Array;
public var uvs :Array;
private function v(x:Number,y:Number,z:Number):void{verts.push(new Vertex3D(x,y,z));}
private function uv(u:Number,v:Number):void{uvs.push(new NumberUV(u,v));}
private function f(vn0:int, vn1:int, vn2:int, uvn0:int, uvn1:int,uvn2:int):void{faceAr.push( new Face3D( [verts[vn0],verts[vn1],verts[vn2] ], null, [uvs[uvn0],uvs[uvn1],uvs[uvn2]] ) );}
public function %( material:MaterialObject3D=null, initObject:Object=null )
{
super( material, new Array(), new Array(), null, initObject );
verts = this.geometry.vertices;
faceAr= this.geometry.faces;
uvs   =new Array();\n",

	papervisionVertexFormat = "v(%,%,%);\n",
	papervisionUVFormat ="uv(%,%);\n",
	papervisionFaceFormat ="f(%,%,%,%,%,%);\n",
	
	
papervisionFooterFormat ="this.geometry.ready = true;
}

}
}",




papervision2HeaderFormat = "package %
{
\timport org.papervision3d.core.*;
\timport org.papervision3d.core.geom.*;
\timport org.papervision3d.core.geom.renderables.Triangle3D;
\timport org.papervision3d.core.geom.renderables.Vertex3D;
\timport org.papervision3d.core.math.NumberUV;
\timport org.papervision3d.core.proto.*;

\tpublic class % extends TriangleMesh3D{
\t\tpublic var verts :Array;
\t\tpublic var faceAr:Array;
\t\tpublic var uvs :Array;
\t\tprivate function v(x:Number,y:Number,z:Number):void{tverts.push(new Vertex3D(x,y,z));}
\t\tprivate function uv(u:Number,v:Number):void{uvs.push(new NumberUV(u,v));}
\t\tprivate function f(vn0:int, vn1:int, vn2:int, uvn0:int, uvn1:int,uvn2:int):void{faceAr.push( new Triangle3D( this, [verts[vn0],verts[vn1],verts[vn2] ], null, [uvs[uvn0],uvs[uvn1],uvs[uvn2]] ) );}
\t\tpublic function %( material:MaterialObject3D=null, initObject:Object=null )
\t\t{
\t\t\tsuper( material, new Array(), new Array(), null, initObject );
\t\t\tverts = this.geometry.vertices;
\t\t\tfaceAr= this.geometry.faces;
\t\t\tuvs   =new Array();\n",

papervisionVertexFormat = "\t\t\tv(%,%,%);\n",
papervisionUVFormat ="\t\t\tuv(%,%);\n",
papervisionFaceFormat ="\t\t\tf(%,%,%,%,%,%);\n",
	
	
papervision2FooterFormat ="
\t\t\tthis.geometry.ready = true;
\t\t}

\t}

}",





sandyHeaderFormat = "package %
{
import sandy.primitive.Primitive3D;
import sandy.core.scenegraph.Geometry3D;
import sandy.core.scenegraph.Shape3D;
public class % extends Shape3D implements Primitive3D{
private var l:Geometry3D ;
private function v(x:Number,y:Number,z:Number):void{l.setVertex(l.getNextVertexID(),x,y,z );}
private function vn(nx:Number,ny:Number,nz:Number):void{l.setVertexNormal(l.getNextVertexNormalID(),nx,ny,nz );}
private function uv(u:Number,v:Number):void{l.setUVCoords(l.getNextUVCoordID(),u,v);}
private function f(vn0:int, vn1:int, vn2:int, uvn0:int, uvn1:int,uvn2:int):void{
l.setFaceVertexIds(l.getNextFaceID(), vn0, vn1,vn2);
l.setFaceUVCoordsIds( l.getNextFaceUVCoordID(), uvn0,uvn1,uvn2);
}
public function %( p_Name:String=null ){
super( p_Name ) ;
geometry = generate() ;
}
public function generate(... arguments):Geometry3D{
l = new Geometry3D();\n",


	sandyVertexFormat = "v(%,%,%);\n",
	sandyVertexNormalFormat = "vn(%,%,%);\n",
	sandyUVFormat ="uv(%,%);\n",
	sandyFaceFormat ="f(%,%,%,%,%,%);\n",
		

sandyFooterFormat ="return (l);
}
}
}"
	
	
	
	
	
	-- Definition de l'interface
	group "AS3GeomExporter  v1.06" 
	(
		bitmap the_bmp fileName:"logo.jpg" height:100
		hyperLink lab1 "www.not-so-stupid.com" address:"http://www.not-so-stupid.com" align:#center
		
		edittext package_txt "Package :" text:"" 
		edittext classname_txt "ClassName :" text:"MyObject"
		dropdownlist cbEngine "Engine" items:engineName 
		spinner scale "Scale :" range:[0.001,1000,1] type:#float
		checkbox exportNormal "Export vertex normal" checked:false enabled:false
		
		checkbox swapNormal "Swap face normal" checked:false
		checkbox rounded "Rounded vertex coord" checked:false
	)
	on cbEngine selected i do (
		exportNormal.enabled   = case cbEngine.selected  of  ( 
			awayLite: false
			away: false
			sandy: true
			papervision: false
			papervision2: false
		) 
	)
	button btn_export "Export Class"
	-- definition des function

	-------------------------------------------------------------------------------------
	-- This function exports all geometry object to as file
	function ExportMesh meshObj name =
	(
		vertexFormat = case cbEngine.selected  of 
		( 
			awayLite: awayLiteVertexFormat
			away: awayVertexFormat
			sandy: sandyVertexFormat
			papervision: papervisionVertexFormat
			papervision2: papervisionVertexFormat
		) 
		vertexNormalFormat = case cbEngine.selected  of 
		( 
			awayLite: awayLiteVertexFormat
			away: awayVertexFormat
			sandy: sandyVertexNormalFormat
			papervision: papervisionVertexFormat
			papervision2: papervisionVertexFormat
		) 
		UVFormat = case cbEngine.selected  of 
		( 
			awayLite: awayLiteUVFormat
			away: awayUVFormat
			sandy: sandyUVFormat
			papervision: papervisionUVFormat
			papervision2: papervisionUVFormat
		) 
		faceFormat = case cbEngine.selected  of 
		( 
			awayLite: awayLiteFaceFormat
			away: awayFaceFormat
			sandy: sandyFaceFormat
			papervision: papervisionFaceFormat
			papervision2: papervisionFaceFormat
		) 
		if exportNormal.enabled then (
	
			-- Vertex normals
				if meshObj.numVerts > 0 and exportNormal.checked then
				(

					for i = 1 to meshObj.numVerts do
					(
						normal =  GetNormal meshObj i 
						normal= normalize normal as point3
					 Format vertexNormalFormat normal.x normal.z normal.y to:ostream

					)
				)
		
		)
		--vertice

		if meshObj.numVerts > 0 then
		(
			for i = 1 to meshObj.numVerts do
			(
				vert = ((GetVert meshObj i)-meshObj.pos)
				if rounded.checked then Format vertexFormat ((ceil (vert.x*scale.value*10 ))/10  ) ((ceil (vert.z*scale.value*10 ))/10  ) ((ceil (vert.y*scale.value*10 ))/10  )  to:ostream
				else Format vertexFormat (vert.x*scale.value  ) (vert.z*scale.value ) (vert.y*scale.value ) to:ostream
			)
		)
		-- Texture coords

		if meshObj.numTVerts > 0  then
		(
			for i = 1 to meshObj.numTVerts do
			(
				uvw = GetTVert meshObj i
				if cbEngine.selected == sandy  then Format UVFormat uvw.x (1-uvw.y)  to:ostream
				else  if cbEngine.selected == papervision  then Format UVFormat uvw.x uvw.y  to:ostream
				else  if cbEngine.selected == papervision2  then Format UVFormat uvw.x uvw.y  to:ostream
  				else  Format UVFormat uvw.x uvw.y  to:ostream
			
			)
		)
		-- Polygon

		if meshObj.NumFaces > 0 then
		(
			for i = 1 to meshObj.numFaces do
			(
				poly = GetFace meshObj i
				tvert = GetTVFace meshObj i
				if swapNormal.checked then Format faceFormat (poly.x as integer -1) (poly.z as integer -1) (poly.y as integer -1) (tvert.x as integer -1) (tvert.z as integer -1) (tvert.y as integer -1) to:ostream
				else Format faceFormat (poly.x as integer -1) (poly.y as integer -1) (poly.z as integer -1) (tvert.x as integer -1) (tvert.y as integer -1) (tvert.z as integer -1) to:ostream
				format "//materialID: %\n" (getFaceMatID meshObj i) to:ostream


			)
		)
	)
	-------------------------------------------------------------------------------------
	-- This function is called once per node in the scene.
	-- A node in Max may be all sorts of things. We are only interested in geometry.
	function ExportNode node =
	(
		-- Create node and export class specific data
		if SuperClassOf node == GeometryClass and ClassOf node == Editable_mesh then
			ExportMesh node node.name
		else if SuperClassOf node == GeometryClass then
		(
			-- Build a mesh out of this object and save it
			local temp = copy node
	
			convertToMesh temp
			ExportMesh temp node.name
			delete temp
		)
		else	-- Not geometry.. could be a camera, light, etc.
			return false

		return true
	)


	-------------------------------------------------------------------------------------
	--export de la class
	function ExportCLASS =
	(
	
		header = case cbEngine.selected  of 
		( 
			awayLite: awayLiteHeaderFormat
			away: awayHeaderFormat
			sandy: sandyHeaderFormat
			papervision: papervisionHeaderFormat
			papervision2: papervision2HeaderFormat
		) 
		footer = case cbEngine.selected  of 
		( 
			awayLite: awayLiteFooterFormat
			away: awayFooterFormat
			sandy: sandyFooterFormat
			papervision: papervisionFooterFormat
			papervision2: papervision2FooterFormat
		) 
		-- Header de la class
		if cbEngine.selected == awayLite  then Format header package_txt.text classname_txt.text classname_txt.text classname_txt.text to:ostream
		else Format header package_txt.text classname_txt.text classname_txt.text to:ostream
		
		
		ExportNode selection[1]

		Format footer to:ostream

	)
	-------------------------------------------------------------------------------------
	-- Open an prepare a file handle for writing.
	function GetSaveFileStream =
	(
		fname = GetSaveFileName filename:classname_txt.text types:"actionscript class (*.as)|*.as|All Files(*.*)|*.*|"
		if fname == undefined then
			return undefined

		ostream = CreateFile fname
		if ostream == undefined then
		(
			MessageBox "Couldn't open file for writing !"
			return undefined
		)

		return ostream
	) 
	-------------------------------------------------------------------------------------
	-- This is the function called when the user activates the utility by pressing on
	-- the export button. It opens the file and calls the export routine.
	on btn_export pressed do
	(
		ostream = GetSaveFileStream()
		if ostream != undefined then
		(
			ExportCLASS()
			close ostream
		)
	)

) 
createDialog AS3GeomClassExporter width:200