﻿package away3d.core.filter
{
	import away3d.arcane;
	import away3d.core.render.*;
	
	use namespace arcane;
	
    /**
    * Defines a maximum allowed drawing primitives.
    */
    public class MaxPolyFilter implements IPrimitiveFilter
    {
		private var _maxP:int;
    	
		/**
		 * Creates a new <code>MaxPolyFilter</code> object.
		 *
		 * @param	maxP		A maximum allowed drawing primitives. Default = 1000;
		 */
		function MaxPolyFilter(maxP:int = 1000)
		{
			_maxP = maxP;
		}
        
		/**
		 * @inheritDoc
		 */
        public function filter(renderer:Renderer):void
        {
			if(renderer._order.length > _maxP)
				renderer._order.splice(_maxP, renderer._order.length - _maxP);
        }
		
		/**
		 * Used to trace the values of a filter.
		 * 
		 * @return A string representation of the filter object.
		 */
        public function toString():String
        {
            return "MaxPolyFilter";
        }
    }
}
