package 
{
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	//
	import away3d.lights.PointLight3D;
	import away3d.extrusions.Elevation;
	import away3d.extrusions.SkinExtrude;
	import away3d.containers.View3D;
	import away3d.core.utils.Cast;
	import away3d.materials.WhiteShadingBitmapMaterial;
	/**
	 * ...
	 * @author 
	 */
	public class ElevationExample extends Sprite 
	{
		private var view:View3D;
		private var texture:WhiteShadingBitmapMaterial;
		private var extrude:SkinExtrude;
		private var elevation:Elevation;
		private var light:PointLight3D;
		private var backward:Boolean = false;
		private var verts:Array;
		
		public function ElevationExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			//
			view = new View3D();
			view.x = 320;
			view.y = 240;
			addChild(view);
			//
			view.camera.y = 600;
			view.camera.lookAt(new Vector3D(0, 0, 0));
			//
			light = new PointLight3D();
			light.specular = .05;
			light.diffuse = 0.75;
			light.ambient = 0.5;
			view.scene.addLight(light);
			//
			texture = new WhiteShadingBitmapMaterial(Cast.bitmap('terrainTexture'));
			texture.smooth = true;
			//
			elevation = new Elevation();
			verts = elevation.generate(Cast.bitmap('terrainMap'), 'r', 10, 10, 2, 2, .25);
			extrude = new SkinExtrude(verts, { coverall:true } );
			extrude.material = texture;
			extrude.rotationX = 90;
			extrude.position = new Vector3D(0, 0, 0);
			extrude.pivotPoint = new Vector3D(256,256,0);
			trace(extrude.x, extrude.y, extrude.z,extrude.pivotPoint);
			view.scene.addChild(extrude);
		}
		
		private function onEnterFrame(e:Event):void
		{
			if (light.x > 400) backward = true;
			if (light.x < -400) backward = false;
			//
			if (backward) light.x--;
			else light.x++;
			extrude.rotationY--;
			view.render();
		}
	}
}