package 
{
	import away3d.core.utils.Init;
	import away3d.cameras.Camera3D;
	import away3d.cameras.lenses.*;
	import flash.display.Stage;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.KeyboardEvent;
	import flash.geom.Vector3D;
	import flash.ui.Keyboard;
	
	public class FPP extends Camera3D
	{
		private var _stage:Stage;
		private var _freeCamera:Boolean = true;
		private var _invertX:Boolean = false;
		private var _invertY:Boolean = false;
		private var _directionX:Number = 1;
		private var _directionY:Number = 1;
		private var _rotationSensitivity:Number = .5;
		private var _rotateOnDrag:Boolean = false;
		private var _height:Number;
		private var _cameraDirectionPoint:Vector3D = new Vector3D();
		private var _moveCamera:Boolean = false;
		private var _shiftDown:Boolean = false;
		private var _leftDown:Boolean = false;
		private var _rightDown:Boolean = false;
		private var _forwardDown:Boolean = false;
		private var _backwardDown:Boolean = false;
		
		public var pitchLimit:Number = 60;
		public var yawLimit:Number = Number.MAX_VALUE;
		
		private static const WALK_SPEED:Number = 10;
		private static const RUN_SPEED:Number = 40;
		
		public function FPP(stage:Stage,init:Object = null):void 
		{
			super(init);
			
			_stage = stage;
			_freeCamera = ini.getBoolean("freeCamera", _freeCamera);
			_height = y =  ini.getNumber("height", 0);
			_invertX = ini.getBoolean("invertX", _invertX);
			_invertY = ini.getBoolean("invertY", _invertY);
			_rotationSensitivity = ini.getNumber("rotationSensitivity", _rotationSensitivity);
			_rotateOnDrag = ini.getBoolean("rotateOnDrag", _rotateOnDrag);
			if (_rotateOnDrag) addMouseEventListeners();
			if (_invertX) _directionX = -1;
			if (_invertY) _directionY = -1;
			addKeyboardEventListeners();
		}
		
		public function updateCamera():void
		{
			_cameraDirectionPoint.x = Math.sin( rotationY * toRADIANS ) * (_shiftDown ? RUN_SPEED : WALK_SPEED); 
			_cameraDirectionPoint.z = Math.cos( rotationY * toRADIANS ) * (_shiftDown ? RUN_SPEED : WALK_SPEED);
			_cameraDirectionPoint.y = y;
			if (_freeCamera)
			{				
				if (_forwardDown)
				{
					x += _cameraDirectionPoint.x;
					z += _cameraDirectionPoint.z;
				}
				if (_backwardDown)
				{
					x -= _cameraDirectionPoint.x;
					z -= _cameraDirectionPoint.z;
				}
				if (_leftDown)
				{
					x -= _cameraDirectionPoint.z;
					z += _cameraDirectionPoint.x;
				}
				if (_rightDown)
				{
					x += _cameraDirectionPoint.z;
					z -= _cameraDirectionPoint.x;
				}
			}
			if ((_rotateOnDrag && _moveCamera) || !_rotateOnDrag)
			{
				rotationY = (_stage.mouseX - _stage.stageWidth * .5) * _directionX * _rotationSensitivity;
				rotationX = (_stage.stageHeight * .5 - _stage.mouseY) * _directionY * _rotationSensitivity;
				
				if (rotationY > yawLimit) rotationY = yawLimit;
				else if (rotationY < -yawLimit) rotationY = -yawLimit;
				else {/**/}
				
				if (rotationX > pitchLimit) rotationX = pitchLimit;
				else if (rotationX < -pitchLimit) rotationX = -pitchLimit;
				else {/**/}
			}
		}
		
		public function get toRADS():Number
		{
			return toRADIANS;
		}
		
		public function get toDEGS():Number
		{
			return toDEGREES;
		}
		
		public function get cameraDirectionPoint():Vector3D
		{
			return _cameraDirectionPoint;
		}
		
		public function set freeCamera(val:Boolean):void
		{
			_freeCamera = val;
		}
		
		public function get freeCamera():Boolean
		{
			return _freeCamera;
		}
		
		public function set invertX(val:Boolean):void
		{
			_invertX = val;
			_directionX = (val) ? -1 : 1;
		}
		
		public function get invertX():Boolean
		{
			return _invertX;
		}
		
		public function set invertY(val:Boolean):void
		{
			_invertY = val;
			_directionY = (val) ? -1 : 1;
		}
		
		public function get invertY():Boolean
		{
			return _invertY;
		}
		
		public function set rotateOnDrag(val:Boolean):void
		{
			_rotateOnDrag = val;
			if(val) addMouseEventListeners();
			else removeMouseEventListeners();
		}
		
		public function get rotateOnDrag():Boolean
		{
			return _rotateOnDrag;
		}
		
		private function addMouseEventListeners():void
		{
			_stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			_stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function removeMouseEventListeners():void
		{
			_stage.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			_stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function addKeyboardEventListeners():void
		{
			_stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			_stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		
		private function removeKeyboardEventListeners():void
		{
			_stage.removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			_stage.removeEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.SHIFT:
				_shiftDown = true;
				break;
				case Keyboard.A:
				_leftDown = true;
				break;
				case Keyboard.D:
				_rightDown = true;
				break;
				case Keyboard.W:
				_forwardDown = true;
				break;
				case Keyboard.S:
				_backwardDown = true;
				break;
				case Keyboard.SPACE:
				break;
			}
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			switch(e.keyCode)
			{
				case Keyboard.SHIFT:
				_shiftDown = false;
				break;
				case Keyboard.A:
				_leftDown = false;
				break;
				case Keyboard.D:
				_rightDown = false;
				break;
				case Keyboard.W:
				_forwardDown = false;
				break;
				case Keyboard.S:
				_backwardDown = false;
				break;
				case Keyboard.SPACE:
				break;
				default:
				break;
			}
		}
		
		private function onMouseDown(e:MouseEvent):void
		{
			_moveCamera = true;
		}
		
		private function onMouseUp(e:MouseEvent):void
		{
			_moveCamera = false;
		}
	}
}