package 
{
	import away3d.lights.PointLight3D;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Vector3D;
	//
	import away3d.modifiers.HeightMapModifier;
	import away3d.primitives.Plane;
	import away3d.containers.View3D;
	import away3d.core.utils.Cast;
	import away3d.materials.WhiteShadingBitmapMaterial;
	/**
	 * ...
	 * @author 
	 */
	public class HeightMapModifierExample extends Sprite 
	{
		private var view:View3D;
		private var texture:WhiteShadingBitmapMaterial;
		private var terrainMap:BitmapData;
		private var plane:Plane;
		private var modifier:HeightMapModifier;
		private var light:PointLight3D;
		private var backward:Boolean = false;
		
		public function HeightMapModifierExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			//
			view = new View3D();
			view.x = 320;
			view.y = 240;
			addChild(view);
			//
			view.camera.y = 600;
			view.camera.lookAt(new Vector3D(0, 0, 0));
			//
			light = new PointLight3D();
			light.specular = .05;
			light.diffuse = 0.75;
			light.ambient = 0.5;
			view.scene.addLight(light);
			//
			texture = new WhiteShadingBitmapMaterial(Cast.bitmap('terrainTexture'));
			texture.smooth = true;
			plane = new Plane();
			plane.material = texture;
			plane.bothsides = true;
			plane.width = plane.height = 512;
			plane.segmentsW = plane.segmentsH = 30;
			view.scene.addChild(plane);
			terrainMap = Cast.bitmap('terrainMap');
			modifier = new HeightMapModifier(plane, terrainMap);
			modifier.scale = .25;
			modifier.execute();
		}
		
		private function onEnterFrame(e:Event):void
		{
			if (light.x > 400) backward = true;
			if (light.x < -400) backward = false;
			//
			if (backward) light.x--;
			else light.x++;
			plane.rotationY--;
			view.render();
		}
	}
}