package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import fl.controls.Label;
	import fl.controls.Button;
	
	public class CameraPropertiesPanel extends Sprite
	{
		private var _output:Label;
		
		public function CameraPropertiesPanel() 
		{
			var animationsLabel:Label = new Label();
            animationsLabel.text = 'Animacje';
			animationsLabel.x = 120;
			animationsLabel.y = 0;
			addChild(animationsLabel);
			
			var focusAnimationButton:Button = new Button();
			focusAnimationButton.name = "focusAnimation";
			focusAnimationButton.label = "Focus";
			focusAnimationButton.x = 20;
			focusAnimationButton.y = 20;
			focusAnimationButton.width = 60;
			addChild(focusAnimationButton);
			focusAnimationButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var zoomAnimationButton:Button = new Button();
			zoomAnimationButton.name = "zoomAnimation";
			zoomAnimationButton.label = "Zoom";
			zoomAnimationButton.x = 90;
			zoomAnimationButton.y = 20;
			zoomAnimationButton.width = 60;
			addChild(zoomAnimationButton);
			zoomAnimationButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var startPositionButton:Button = new Button();
			startPositionButton.name = "startPosition";
			startPositionButton.label = "Pozycja początkowa";
			startPositionButton.x = 160;
			startPositionButton.y = 20;
			startPositionButton.width = 120;
			addChild(startPositionButton);
			startPositionButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var zoomLabel:Label = new Label();
            zoomLabel.text = 'Zoom';
			zoomLabel.x = 320;
			zoomLabel.y = 0;
			addChild(zoomLabel);
			
			var zoomLessButton:Button = new Button();
			zoomLessButton.name = "zoomLess";
			zoomLessButton.label = "-";
			zoomLessButton.x = 300;
			zoomLessButton.y = 20;
			zoomLessButton.width = 30;
			addChild(zoomLessButton);
			zoomLessButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var zoomMoreButton:Button = new Button();
			zoomMoreButton.name = "zoomMore";
			zoomMoreButton.label = "+";
			zoomMoreButton.x = 340;
			zoomMoreButton.y = 20;
			zoomMoreButton.width = 30;
			addChild(zoomMoreButton);
			zoomMoreButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var focusLabel:Label = new Label();
            focusLabel.text = 'Focus';
			focusLabel.x = 407;
			focusLabel.y = 0;
			addChild(focusLabel);
			
			var focusLessButton:Button = new Button();
			focusLessButton.name = "focusLess";
			focusLessButton.label = "-";
			focusLessButton.x = 390;
			focusLessButton.y = 20;
			focusLessButton.width = 30;
			addChild(focusLessButton);
			focusLessButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			var focusMoreButton:Button = new Button();
			focusMoreButton.name = "focusMore";
			focusMoreButton.label = "+";
			focusMoreButton.x = 430;
			focusMoreButton.y = 20;
			focusMoreButton.width = 30;
			addChild(focusMoreButton);
			focusMoreButton.addEventListener(MouseEvent.CLICK, buttonClick);
			
			_output = new Label();
			_output.x = 20;
			_output.y = 50;
			_output.text = 'wyniki > ';
			addChild(_output);
		}
		
		public function updateOutput(zoom:Number, focus:Number, fov:Number):void
		{
			_output.text = 'wyniki > zoom: ' + zoom + ' focus: ' + focus + ' fov: ' + fov;
		}
		
		private function buttonClick(e:MouseEvent):void
		{
			dispatchEvent(new Event(e.target.name + 'Event'));
		}
		
		public function draw(_width:Number, _height:Number, _color:uint = 0xF1F1F1, _alpha:int = 1):void
		{
			graphics.clear();
			graphics.beginFill(_color,_alpha);
			graphics.drawRect(0, 0, _width, _height);
			graphics.endFill();
			_output.width = _width - 40;
		}
	}
}