// Szkic oparty na szkicu “listener” i innych przykładowych szkicach firmy Adafruit.
// Uwaga: zakładam, że stosujesz sterowniki silników firmy Makeblock, 
// których praca jest sterowana za pomocą dwóch złącz.

#include <Adafruit_NECremote.h>

int drc1 = 5; // HIGH = do przodu, LOW = do tyłu
int pwm1 = 6; // szybkość pracy silnika
int drc2 = 10;
int pwm2 = 11;
#define IRpin 7 // Do którego pinu podłączyłeś czujnik podczerwieni?

Adafruit_NECremote remote(IRpin);

void setup(void) {
   Serial.begin(9600);

   pinMode(drc1, OUTPUT);
   pinMode(pwm1, OUTPUT);
   pinMode(drc2, OUTPUT);
   pinMode(pwm2, OUTPUT);

}

void loop(void) {
   int c = remote.listen(5); // Ilość czasu, jaka upłynie przed przerwą!

   if (c == 5) {

      // Oba silniki napędzają pojazd do przodu.
      Serial.println("Do przodu");
      digitalWrite(drc1, HIGH); // Pierwszy silnik pracuje do przodu.
      digitalWrite(pwm1, 100);
      digitalWrite(drc2, LOW); // Drugi silnik pracuje do tyłu.
      // Drugi silnik obraca się w przeciwnym kierunku, ponieważ znajduje się on po przeciwnej stronie pojazdu.
      digitalWrite(pwm2, 100);
      delay(100);

   }
   else if (c == 10) {
      // Lewy silnik pracuje do przodu, a prawy do tyłu.
      Serial.println("W prawo");
      digitalWrite(drc1, HIGH);
      digitalWrite(pwm1, 100);
      digitalWrite(drc2, HIGH); // Pamiętaj, że silnik numer dwa jest zainstalowany po przeciwnej stronie.
      digitalWrite(pwm2, 100);
      delay(100);

   }
   else if (c == 8) {
      // Prawy silnik pracuje do przodu, a lewy do tyłu.
      Serial.println("W lewo");
      digitalWrite(drc1, LOW);
      digitalWrite(pwm1, 100);
      digitalWrite(drc2, LOW);
      digitalWrite(pwm2, 100);
      delay(100);

   }
   else if (c == 13) {
      // Oba silniki napędzają pojazd do tyłu
      Serial.println("Do tylu");
      digitalWrite(drc1, LOW);
      digitalWrite(pwm1, 100);
      digitalWrite(drc2, HIGH); // Pamiętaj, że silnik numer dwa jest zainstalowany po przeciwnej stronie.
      digitalWrite(pwm2, 100);
      delay(100);
   }

}

