#include <AFMotor.h>

AF_DCMotor motorleft(1);
AF_DCMotor motorright(4);
const int pingPin = 7;

void setup() {
   Serial.begin(9600);

   motorleft.setSpeed(50);
   motorright.setSpeed(50);
}

void loop()
{
   uint8_t i;

   long duration, inches, cm;

   pinMode(pingPin, OUTPUT);
   digitalWrite(pingPin, LOW);
   delayMicroseconds(2);
   digitalWrite(pingPin, HIGH);
   delayMicroseconds(5);
   digitalWrite(pingPin, LOW);

   pinMode(pingPin, INPUT);
   duration = pulseIn(pingPin, HIGH);

   cm = microsecondsToCentimeters(duration);

   Serial.print(cm);
   Serial.print("cm");
   Serial.println();

   if (cm > 10) {
   motorleft.run(BACKWARD);
   for (i=0; i<255; i++) {
      motorleft.setSpeed(i);
      delay(10);
   }

   motorright.run(BACKWARD);
   for (i=0; i<255; i++) {
      motorright.setSpeed(i);
      delay(10);
   }

   motorleft.run(RELEASE);
   motorright.run(RELEASE);
   delay(30);
   }
}
long microsecondsToCentimeters(long microseconds)
{ 
return microseconds / 29 / 2;
}

