// Plik z implementacją parsera wygenerowanego przez FsYacc
module Symbolic.Expressions.ExprParser
#nowarn "64";; // Wyłączanie ostrzeżeń informujących, że zmienne używane w adnotacjach w kodzie produkcyjnym są używane jako typy konkretne
open Microsoft.FSharp.Text.Lexing
open Microsoft.FSharp.Text.Parsing.ParseHelpers
# 1 "ExprParser.fsy"

open System
open Symbolic.Expressions

# 11 "ExprParser.fs"
// Typ z tokenami akceptowanymi przez parser
type token = 
  | EOF
  | LPAREN
  | RPAREN
  | PLUS
  | MINUS
  | TIMES
  | DIV
  | HAT
  | SIN
  | COS
  | E
  | ID of (string)
  | FLOAT of (float)
  | INT of (int)
// Ten tym określa nazwy symboliczne dla indeksów, przydatne w komunikatach o błędach
type tokenId = 
    | TOKEN_EOF
    | TOKEN_LPAREN
    | TOKEN_RPAREN
    | TOKEN_PLUS
    | TOKEN_MINUS
    | TOKEN_TIMES
    | TOKEN_DIV
    | TOKEN_HAT
    | TOKEN_SIN
    | TOKEN_COS
    | TOKEN_E
    | TOKEN_ID
    | TOKEN_FLOAT
    | TOKEN_INT
    | TOKEN_end_of_input
    | TOKEN_error
// Ten tym określa nazwy symboliczne dla indeksów, przydatne w komunikatach o błędach
type nonTerminalId = 
    | NONTERM__startexpr
    | NONTERM_expr
    | NONTERM_number
    | NONTERM_exp
    | NONTERM_term

// Ta funkcja odwzorowuje tokeny na indeksy całkowitoliczbowe
let tagOfToken (t:token) = 
  match t with
  | EOF  -> 0 
  | LPAREN  -> 1 
  | RPAREN  -> 2 
  | PLUS  -> 3 
  | MINUS  -> 4 
  | TIMES  -> 5 
  | DIV  -> 6 
  | HAT  -> 7 
  | SIN  -> 8 
  | COS  -> 9 
  | E  -> 10 
  | ID _ -> 11 
  | FLOAT _ -> 12 
  | INT _ -> 13 

// Ta funkcja odwzorowuje indeksy całkowitoliczbowe na symboliczne identyfikatory tokenów
let tokenTagToTokenId (tokenIdx:int) = 
  match tokenIdx with
  | 0 -> TOKEN_EOF 
  | 1 -> TOKEN_LPAREN 
  | 2 -> TOKEN_RPAREN 
  | 3 -> TOKEN_PLUS 
  | 4 -> TOKEN_MINUS 
  | 5 -> TOKEN_TIMES 
  | 6 -> TOKEN_DIV 
  | 7 -> TOKEN_HAT 
  | 8 -> TOKEN_SIN 
  | 9 -> TOKEN_COS 
  | 10 -> TOKEN_E 
  | 11 -> TOKEN_ID 
  | 12 -> TOKEN_FLOAT 
  | 13 -> TOKEN_INT 
  | 16 -> TOKEN_end_of_input
  | 14 -> TOKEN_error
  | _ -> failwith "tokenTagToTokenId: nieodpowiedni token"

/// Ta funkcja odwzorowuje indeksy zwracane w błędach składni na łańcuchy znaków reprezentujące błąd niekrytyczny generowany w danym środowisku
let prodIdxToNonTerminal (prodIdx:int) = 
  match prodIdx with
    | 0 -> NONTERM__startexpr 
    | 1 -> NONTERM_expr 
    | 2 -> NONTERM_number 
    | 3 -> NONTERM_number 
    | 4 -> NONTERM_number 
    | 5 -> NONTERM_number 
    | 6 -> NONTERM_exp 
    | 7 -> NONTERM_exp 
    | 8 -> NONTERM_exp 
    | 9 -> NONTERM_exp 
    | 10 -> NONTERM_exp 
    | 11 -> NONTERM_exp 
    | 12 -> NONTERM_exp 
    | 13 -> NONTERM_exp 
    | 14 -> NONTERM_exp 
    | 15 -> NONTERM_exp 
    | 16 -> NONTERM_exp 
    | 17 -> NONTERM_exp 
    | 18 -> NONTERM_exp 
    | 19 -> NONTERM_term 
    | 20 -> NONTERM_term 
    | 21 -> NONTERM_term 
    | _ -> failwith "prodIdxToNonTerminal: nieodpowiedni indeks"

let _fsyacc_endOfInputTag = 16 
let _fsyacc_tagOfErrorTerminal = 14

// Ta funkcja pobiera nazwę tokenu jako łańcuch znaków
let token_to_string (t:token) = 
  match t with 
  | EOF  -> "EOF" 
  | LPAREN  -> "LPAREN" 
  | RPAREN  -> "RPAREN" 
  | PLUS  -> "PLUS" 
  | MINUS  -> "MINUS" 
  | TIMES  -> "TIMES" 
  | DIV  -> "DIV" 
  | HAT  -> "HAT" 
  | SIN  -> "SIN" 
  | COS  -> "COS" 
  | E  -> "E" 
  | ID _ -> "ID" 
  | FLOAT _ -> "FLOAT" 
  | INT _ -> "INT" 

// Ta funkcja pobiera dane z tokenu jako obiekt
let _fsyacc_dataOfToken (t:token) = 
  match t with 
  | EOF  -> (null : System.Object) 
  | LPAREN  -> (null : System.Object) 
  | RPAREN  -> (null : System.Object) 
  | PLUS  -> (null : System.Object) 
  | MINUS  -> (null : System.Object) 
  | TIMES  -> (null : System.Object) 
  | DIV  -> (null : System.Object) 
  | HAT  -> (null : System.Object) 
  | SIN  -> (null : System.Object) 
  | COS  -> (null : System.Object) 
  | E  -> (null : System.Object) 
  | ID _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | FLOAT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
let _fsyacc_gotos = [| 0us; 65535us; 1us; 65535us; 0us; 1us; 13us; 65535us; 0us; 10us; 21us; 10us; 22us; 10us; 23us; 10us; 24us; 10us; 26us; 10us; 29us; 10us; 32us; 10us; 34us; 35us; 36us; 10us; 38us; 10us; 41us; 42us; 43us; 44us; 10us; 65535us; 0us; 2us; 21us; 12us; 22us; 13us; 23us; 14us; 24us; 15us; 26us; 16us; 29us; 17us; 32us; 18us; 36us; 19us; 38us; 20us; 10us; 65535us; 0us; 33us; 21us; 33us; 22us; 33us; 23us; 33us; 24us; 33us; 26us; 33us; 29us; 33us; 32us; 33us; 36us; 33us; 38us; 33us; |]
let _fsyacc_sparseGotoTableRowOffsets = [|0us; 1us; 3us; 17us; 28us; |]
let _fsyacc_stateToProdIdxsTableElements = [| 1us; 0us; 1us; 0us; 6us; 1us; 8us; 9us; 10us; 11us; 16us; 1us; 1us; 1us; 2us; 1us; 3us; 2us; 4us; 5us; 3us; 4us; 5us; 18us; 1us; 4us; 1us; 5us; 3us; 6us; 19us; 20us; 2us; 7us; 21us; 6us; 8us; 8us; 9us; 10us; 11us; 16us; 6us; 8us; 9us; 9us; 10us; 11us; 16us; 6us; 8us; 9us; 10us; 10us; 11us; 16us; 6us; 8us; 9us; 10us; 11us; 11us; 16us; 6us; 8us; 9us; 10us; 11us; 12us; 16us; 6us; 8us; 9us; 10us; 11us; 13us; 16us; 6us; 8us; 9us; 10us; 11us; 14us; 16us; 6us; 8us; 9us; 10us; 11us; 16us; 17us; 6us; 8us; 9us; 10us; 11us; 16us; 18us; 1us; 8us; 1us; 9us; 1us; 10us; 1us; 11us; 1us; 12us; 1us; 12us; 1us; 12us; 1us; 13us; 1us; 13us; 1us; 13us; 1us; 14us; 1us; 14us; 1us; 15us; 1us; 16us; 1us; 16us; 1us; 17us; 1us; 17us; 1us; 18us; 1us; 18us; 2us; 19us; 20us; 1us; 20us; 1us; 20us; 1us; 21us; 1us; 21us; |]
let _fsyacc_stateToProdIdxsTableRowOffsets = [|0us; 2us; 4us; 11us; 13us; 15us; 17us; 20us; 24us; 26us; 28us; 32us; 35us; 42us; 49us; 56us; 63us; 70us; 77us; 84us; 91us; 98us; 100us; 102us; 104us; 106us; 108us; 110us; 112us; 114us; 116us; 118us; 120us; 122us; 124us; 126us; 128us; 130us; 132us; 134us; 136us; 139us; 141us; 143us; 145us; |]
let _fsyacc_action_rows = 45
let _fsyacc_actionTableElements = [|8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 0us; 49152us; 6us; 32768us; 0us; 3us; 3us; 21us; 4us; 22us; 5us; 23us; 6us; 24us; 7us; 34us; 0us; 16385us; 0us; 16386us; 0us; 16387us; 2us; 32768us; 12us; 9us; 13us; 8us; 3us; 32768us; 1us; 38us; 12us; 9us; 13us; 8us; 0us; 16388us; 0us; 16389us; 1us; 16390us; 11us; 40us; 1us; 16391us; 7us; 43us; 3us; 16392us; 5us; 23us; 6us; 24us; 7us; 34us; 3us; 16393us; 5us; 23us; 6us; 24us; 7us; 34us; 1us; 16394us; 7us; 34us; 1us; 16395us; 7us; 34us; 6us; 32768us; 2us; 27us; 3us; 21us; 4us; 22us; 5us; 23us; 6us; 24us; 7us; 34us; 6us; 32768us; 2us; 30us; 3us; 21us; 4us; 22us; 5us; 23us; 6us; 24us; 7us; 34us; 0us; 16398us; 6us; 32768us; 2us; 37us; 3us; 21us; 4us; 22us; 5us; 23us; 6us; 24us; 7us; 34us; 6us; 32768us; 2us; 39us; 3us; 21us; 4us; 22us; 5us; 23us; 6us; 24us; 7us; 34us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 1us; 32768us; 1us; 26us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 0us; 16396us; 1us; 32768us; 1us; 29us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 0us; 16397us; 1us; 32768us; 7us; 32us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 0us; 16399us; 3us; 32768us; 4us; 6us; 12us; 5us; 13us; 4us; 0us; 16400us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 0us; 16401us; 8us; 32768us; 1us; 36us; 4us; 7us; 8us; 25us; 9us; 28us; 10us; 31us; 11us; 11us; 12us; 5us; 13us; 4us; 0us; 16402us; 1us; 16403us; 7us; 41us; 3us; 32768us; 4us; 6us; 12us; 5us; 13us; 4us; 0us; 16404us; 3us; 32768us; 4us; 6us; 12us; 5us; 13us; 4us; 0us; 16405us; |]
let _fsyacc_actionTableRowOffsets = [|0us; 9us; 10us; 17us; 18us; 19us; 20us; 23us; 27us; 28us; 29us; 31us; 33us; 37us; 41us; 43us; 45us; 52us; 59us; 60us; 67us; 74us; 83us; 92us; 101us; 110us; 112us; 121us; 122us; 124us; 133us; 134us; 136us; 145us; 146us; 150us; 151us; 160us; 161us; 170us; 171us; 173us; 177us; 178us; 182us; |]
let _fsyacc_reductionSymbolCounts = [|1us; 2us; 1us; 1us; 2us; 2us; 1us; 1us; 3us; 3us; 3us; 3us; 4us; 4us; 3us; 1us; 3us; 3us; 4us; 2us; 4us; 3us; |]
let _fsyacc_productionToNonTerminalTable = [|0us; 1us; 2us; 2us; 2us; 2us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 4us; 4us; 4us; |]
let _fsyacc_immediateActions = [|65535us; 49152us; 65535us; 16385us; 16386us; 16387us; 65535us; 65535us; 16388us; 16389us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16396us; 65535us; 65535us; 16397us; 65535us; 65535us; 16399us; 65535us; 16400us; 65535us; 16401us; 65535us; 16402us; 65535us; 65535us; 16404us; 65535us; 16405us; |]
let _fsyacc_reductions ()  =    [| 
# 169 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Expr)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startexpr));
# 178 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 25 "ExprParser.fsy"
                                     _1 
                   )
# 25 "ExprParser.fsy"
                 : Expr));
# 189 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : int)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 28 "ExprParser.fsy"
                                                           Convert.ToDecimal(_1) 
                   )
# 28 "ExprParser.fsy"
                 : 'number));
# 200 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : float)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 29 "ExprParser.fsy"
                                                           Convert.ToDecimal(_1) 
                   )
# 29 "ExprParser.fsy"
                 : 'number));
# 211 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : int)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 30 "ExprParser.fsy"
                                                           Convert.ToDecimal(-_2) 
                   )
# 30 "ExprParser.fsy"
                 : 'number));
# 222 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : float)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 31 "ExprParser.fsy"
                                                           Convert.ToDecimal(-_2) 
                   )
# 31 "ExprParser.fsy"
                 : 'number));
# 233 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'number)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 35 "ExprParser.fsy"
                                                     Num _1 
                   )
# 35 "ExprParser.fsy"
                 : 'exp));
# 244 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 36 "ExprParser.fsy"
                                                     Var _1 
                   )
# 36 "ExprParser.fsy"
                 : 'exp));
# 255 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 37 "ExprParser.fsy"
                                                     Add [_1; _3] 
                   )
# 37 "ExprParser.fsy"
                 : 'exp));
# 267 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 38 "ExprParser.fsy"
                                                     Sub (_1, [_3]) 
                   )
# 38 "ExprParser.fsy"
                 : 'exp));
# 279 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 39 "ExprParser.fsy"
                                                     Prod (_1, _3) 
                   )
# 39 "ExprParser.fsy"
                 : 'exp));
# 291 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 40 "ExprParser.fsy"
                                                     Frac (_1, _3) 
                   )
# 40 "ExprParser.fsy"
                 : 'exp));
# 303 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 41 "ExprParser.fsy"
                                                     Sin _3 
                   )
# 41 "ExprParser.fsy"
                 : 'exp));
# 314 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 42 "ExprParser.fsy"
                                                     Cos _3 
                   )
# 42 "ExprParser.fsy"
                 : 'exp));
# 325 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 43 "ExprParser.fsy"
                                                     Exp _3 
                   )
# 43 "ExprParser.fsy"
                 : 'exp));
# 336 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 44 "ExprParser.fsy"
                                                     _1 
                   )
# 44 "ExprParser.fsy"
                 : 'exp));
# 347 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'number)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 45 "ExprParser.fsy"
                                                     Pow (_1, _3) 
                   )
# 45 "ExprParser.fsy"
                 : 'exp));
# 359 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 46 "ExprParser.fsy"
                                                     _2 
                   )
# 46 "ExprParser.fsy"
                 : 'exp));
# 370 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'exp)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 47 "ExprParser.fsy"
                                                     Neg _3 
                   )
# 47 "ExprParser.fsy"
                 : 'exp));
# 381 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'number)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 50 "ExprParser.fsy"
                                                     Prod (Num _1, Var _2) 
                   )
# 50 "ExprParser.fsy"
                 : 'term));
# 393 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'number)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'number)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 51 "ExprParser.fsy"
                                                     Prod (Num _1, Pow (Var _2, _4)) 
                   )
# 51 "ExprParser.fsy"
                 : 'term));
# 406 "ExprParser.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'number)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 52 "ExprParser.fsy"
                                                     Prod (Num 1M, Pow (Var _1, _3)) 
                   )
# 52 "ExprParser.fsy"
                 : 'term));
|]
# 419 "ExprParser.fs"
let tables () : Microsoft.FSharp.Text.Parsing.Tables<_> = 
  { reductions= _fsyacc_reductions ();
    endOfInputTag = _fsyacc_endOfInputTag;
    tagOfToken = tagOfToken;
    dataOfToken = _fsyacc_dataOfToken; 
    actionTableElements = _fsyacc_actionTableElements;
    actionTableRowOffsets = _fsyacc_actionTableRowOffsets;
    stateToProdIdxsTableElements = _fsyacc_stateToProdIdxsTableElements;
    stateToProdIdxsTableRowOffsets = _fsyacc_stateToProdIdxsTableRowOffsets;
    reductionSymbolCounts = _fsyacc_reductionSymbolCounts;
    immediateActions = _fsyacc_immediateActions;
    gotos = _fsyacc_gotos;
    sparseGotoTableRowOffsets = _fsyacc_sparseGotoTableRowOffsets;
    tagOfErrorTerminal = _fsyacc_tagOfErrorTerminal;
    parseError = (fun (ctxt:Microsoft.FSharp.Text.Parsing.ParseErrorContext<_>) -> 
                              match parse_error_rich with 
                              | Some f -> f ctxt
                              | None -> parse_error ctxt.Message);
    numTerminals = 17;
    productionToNonTerminalTable = _fsyacc_productionToNonTerminalTable  }
let engine lexer lexbuf startState = (tables ()).Interpret(lexer, lexbuf, startState)
let expr lexer lexbuf : Expr =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 0))
