open System.IO
let watcher = new FileSystemWatcher(__SOURCE_DIRECTORY__, EnableRaisingEvents = true)
watcher.Changed.Add(fun args -> printfn "Plik %s został zmodyfikowany!" args.Name)
//val watcher : System.IO.FileSystemWatcher = System.IO.FileSystemWatcher
//val it : unit = ()
//Plik f3ovfhv3.xe4~ został zmodyfikowany!
//Plik Script.fsx~RF96906f.TMP został zmodyfikowany!

watcher.Dispose()
//val it : unit = ()

open System
open System.Windows.Forms

type RandomTicker(approxInterval) =
    let timer = new Timer()
    let rnd = new System.Random(99)
    let tickEvent = new Event<int> ()

    let chooseInterval() : int =
        approxInterval + approxInterval / 4 - rnd.Next(approxInterval / 2)

    do timer.Interval <- chooseInterval()

    do timer.Tick.Add(fun args ->
        let interval = chooseInterval()
        tickEvent.Trigger interval;
        timer.Interval <- interval)

    member x.RandomTick = tickEvent.Publish
    member x.Start() = timer.Start()
    member x.Stop() = timer.Stop()
    interface IDisposable with
        member x.Dispose() = timer.Dispose()
//type RandomTicker =
//  class
//    interface System.IDisposable
//    new : approxInterval:int -> RandomTicker
//    member Start : unit -> unit
//    member Stop : unit -> unit
//    member RandomTick : IEvent<int>
//  end

let rt = new RandomTicker(1000)
rt.RandomTick.Add(fun nextInterval -> printfn "Tik, następny = %A" nextInterval)
rt.Start()
//val rt : RandomTicker
//val it : unit = ()
//
//Tik, następny = 818
//Tik, następny = 767
//Tik, następny = 906
//Tik, następny = 799
//Tik, następny = 1213
//Tik, następny = 1119
//Tik, następny = 1196
//Tik, następny = 1138
//...

rt.Stop()
//val it : unit = ()

open System.Windows.Forms
let form = new Form(Text = "Formularz do przesuwania myszy", Visible = true, TopMost = true)
form.MouseMove.Add(fun args -> printfn "Mysz, (X, Y) = (%A, %A)" args.X args.Y)

form.MouseMove
    |> Event.filter (fun args -> args.X > 100)
    |> Event.add (fun args -> printfn "Mysz, (X, Y) = (%A, %A)" args.X args.Y)

//val form : System.Windows.Forms.Form =
//  System.Windows.Forms.Form, Text: Formularz do przesuwania myszy
//val it : unit = ()
//
//Mysz, (X, Y) = (27, 2)
//Mysz, (X, Y) = (26, 3)
//Mysz, (X, Y) = (26, 4)
//Mysz, (X, Y) = (24, 6)
//Mysz, (X, Y) = (23, 7)
//Mysz, (X, Y) = (23, 8)
//Mysz, (X, Y) = (20, 10)
//Mysz, (X, Y) = (19, 11)
//Mysz, (X, Y) = (18, 14)
//Mysz, (X, Y) = (16, 15)
//Mysz, (X, Y) = (15, 16)
//Mysz, (X, Y) = (14, 18)
//Mysz, (X, Y) = (11, 20)
//Mysz, (X, Y) = (10, 22)
//Mysz, (X, Y) = (8, 23)
//Mysz, (X, Y) = (6, 26)
//Mysz, (X, Y) = (3, 28)
//Mysz, (X, Y) = (2, 30)

Event.add
Event.choose
Event.filter
Event.map
Event.merge
Event.pairwise
Event.partition
Event.scan
Event.split
// UWAGA: przy próbie wyświetlenia typów w narzędziu F# Interactive wystąpił następujący błąd:
// error FS0335: Could not resolve the ambiguity in the use of a generic construct with a 'delegate' constraint at or near this position

let rt = new RandomTicker(1000)
rt.Start()
rt.RandomTick |> Observable.add (fun evArgs -> printfn "Tik")
//val rt : RandomTicker
//val it : unit = ()
//
//Tik
//Tik
//Tik
//Tik
//Tik

rt.Stop()
//val it : unit = ()

open System.Net
open System.IO

let museums = 
    [ "MOMA", "http://moma.org/";
      "British Museum", "http://www.thebritishmuseum.ac.uk/";
      "Prado", "http://www.museodelprado.es/" ]

let fetchAsync(nm, url : string) = 
    async {
        printfn "Tworzenie żądania strony %s..." nm
        let req = WebRequest.Create(url)

        let! resp = req.AsyncGetResponse()

        printfn "Pobieranie odpowiedzi ze strony %s..." nm
        let stream = resp.GetResponseStream()

        printfn "Odczytywanie odpowiedzi ze strony %s..." nm
        let reader = new StreamReader(stream)
        let html = reader.ReadToEnd()

        printfn "Wczytano %d znaków ze strony %s..." html.Length nm
    }

Async.Parallel [for nm, url in museums -> fetchAsync(nm, url)]
    |> Async.Ignore
    |> Async.RunSynchronously

//Tworzenie żądania strony British Museum...
//Tworzenie żądania strony Prado...
//Tworzenie żądania strony MOMA...
//Pobieranie odpowiedzi ze strony MOMA...
//Odczytywanie odpowiedzi ze strony MOMA...
//Wczytano 43570 znaków ze strony MOMA...
//Pobieranie odpowiedzi ze strony British Museum...
//Odczytywanie odpowiedzi ze strony British Museum...
//Wczytano 42217 znaków ze strony British Museum...
//Pobieranie odpowiedzi ze strony Prado...
//Odczytywanie odpowiedzi ze strony Prado...
//Wczytano 22406 znaków ze strony Prado...
//
//val museums : (string * string) list =
//  [("MOMA", "http://moma.org/");
//   ("British Museum", "http://www.thebritishmuseum.ac.uk/");
//   ("Prado", "http://www.museodelprado.es/")]
//val fetchAsync : nm:string * url:string -> Async<unit>
//val it : unit = ()

let tprintfn fmt =
    printf "[Wątek %d]" System.Threading.Thread.CurrentThread.ManagedThreadId;
    printfn fmt

let fetchAsync'(nm, url : string) = 
    async {
        tprintfn "Tworzenie żądania strony %s..." nm
        let req = WebRequest.Create(url)

        let! resp = req.AsyncGetResponse()

        tprintfn "Pobieranie odpowiedzi ze strony %s..." nm
        let stream = resp.GetResponseStream()

        tprintfn "Odczytywanie odpowiedzi ze strony %s..." nm
        let reader = new StreamReader(stream)
        let html = reader.ReadToEnd()

        tprintfn "Wczytano %d znaków ze strony %s..." html.Length nm
    }

Async.Parallel [for nm, url in museums -> fetchAsync'(nm, url)]
    |> Async.Ignore
    |> Async.RunSynchronously

//[Wątek 5]Tworzenie żądania strony Prado...
//[Wątek 4]Tworzenie żądania strony British Museum...
//[Wątek 6]Tworzenie żądania strony MOMA...
//[Wątek 20]Pobieranie odpowiedzi ze strony British Museum...
//[Wątek 20]Odczytywanie odpowiedzi ze strony British Museum...
//[Wątek 20]Wczytano 42216 znaków ze strony British Museum...
//[Wątek 22]Pobieranie odpowiedzi ze strony MOMA...
//[Wątek 22]Odczytywanie odpowiedzi ze strony MOMA...
//[Wątek 22]Wczytano 44851 znaków ze strony MOMA...
//[Wątek 21]Pobieranie odpowiedzi ze strony Prado...
//[Wątek 21]Odczytywanie odpowiedzi ze strony Prado...
//[Wątek 21]Wczytano 22406 znaków ze strony Prado...
//
//val tprintfn : fmt:Printf.TextWriterFormat<'a> -> 'a
//val fetchAsync' : nm:string * url:string -> Async<unit>
//val it : unit = ()

let fetchAsync''(nm, url : string) = async.Delay(fun () ->
    printfn "Tworzenie żądania strony %s..." nm
    let req = WebRequest.Create(url)
    async.Bind(req.AsyncGetResponse(), (fun resp ->
        printfn "Odczytywanie odpowiedzi ze strony %s..." nm
        let stream = resp.GetResponseStream() 

        printfn "Odczytywanie odpowiedzi ze strony %s..." nm
        let reader = new StreamReader(stream)  
        async.Bind(async.Return(reader.ReadToEnd()), (fun html ->
            printfn "Wczytano %d znaków ze strony %s..." html.Length nm
            async.Return html)))))

Async.Parallel [for nm, url in museums -> fetchAsync''(nm, url)]
    |> Async.Ignore
    |> Async.RunSynchronously

#I "packages/FSharpx.Async/lib/net40"
#r "FSharpx.Async.dll"
open System.IO
open System.Net
open FSharp.Control.WebExtensions
open FSharpx.Control

//AsyncGetResponse: ten konstrukt jest przestarzały. Metoda rozszerzająca znajduje się w module 'WebExtensions' w głównej bibliotece F#. 
//Dodaj instrukcję 'open Microsoft.FSharp.Control.WebExtensions', aby uzyskać dostęp do potrzebnej metody

//"Metoda rozszerzająca AsyncReadToEnd() z typu StreamReader jest teraz częścią pakietu FSharpPowerPack."
//"Metoda rozszerzająca AsyncReadToEnd została usunięta z najnowszej wersji pakietu PowerPack"
//ŹRÓDŁO: http://stackoverflow.com/questions/8695493/the-field-constructor-or-member-asyncreadtoend-is-not-defined-error
// Moim zdaniem metoda AsyncReadToEnd, która po prostu synchronicznie wywołuje ReadToEnd w odrębnym wątku, to złe rozwiązanie.

//Pakiet F# PowerPack zawiera też typ AsyncStreamReader zawierający poprawną asynchroniczną implementację wczytywania strumieni.
//ŹRÓDŁO: http://stackoverflow.com/questions/7925318/expensive-asynchronous-reading-of-response-stream/7925440#7925440

let moma : Async<string> = async { 
        let req = WebRequest.Create("http://moma.org/")
        let! resp = req.AsyncGetResponse()
        let stream = resp.GetResponseStream()
        let reader = new StreamReader(stream)
        let! html = reader.AsyncReadToEnd()
        return html
    }

let moma' : Async<string> = async.Delay(fun () ->
    let req = WebRequest.Create("http://moma.org/")
    async.Bind(req.AsyncGetResponse(), (fun resp ->
        let stream = resp.GetResponseStream() 
        let reader = new StreamReader(stream)  
        async.Bind(reader.AsyncReadToEnd(), (fun html ->
            async.Return html)))))
//val moma : Async<string>
//val moma' : Async<string>

Async.RunSynchronously moma
Async.RunSynchronously moma'
//val it : string =
//  "<!DOCTYPE html>
//<html lang='en'>
//<head>
//...
//<title>MoMA | Museum of Modern Art</title>
//...
//</html>

open System.IO
let numImages = 200
let size = 512
let numPixels = size * size

let makeImageFiles () =
    printfn "Generowanie %d rysunków o wymiarach %dx%d... " numImages size size
    let pixels = Array.init numPixels (fun i -> byte i)
    for i = 1 to numImages  do
        System.IO.File.WriteAllBytes(sprintf "Image%d.tmp" i, pixels)
    printfn "Gotowe."

let processImageRepeats = 20

let transformImage (pixels, imageNum) =
    printfn "transformImage %d" imageNum;
    // Wykonywanie na rysunku operacji obciążających procesor
    for i in 1 .. processImageRepeats do 
        pixels |> Array.map (fun b -> b + 1uy) |> ignore
    pixels |> Array.map (fun b -> b + 1uy)

let processImageSync i =
    use inStream =  File.OpenRead(sprintf "Image%d.tmp" i)
    let pixels = Array.zeroCreate numPixels
    let nPixels = inStream.Read(pixels,0,numPixels);
    let pixels' = transformImage(pixels,i)
    use outStream =  File.OpenWrite(sprintf "Image%d.done" i)
    outStream.Write(pixels',0,numPixels)

let processImagesSync () =
    printfn "processImagesSync...";
    for i in 1 .. numImages do
        processImageSync(i)

let processImageAsync i =
    async { 
        use inStream = File.OpenRead(sprintf "Image%d.tmp" i)
        let! pixels = inStream.AsyncRead(numPixels)
        let  pixels' = transformImage(pixels, i)
        use outStream = File.OpenWrite(sprintf "Image%d.done" i)
        do! outStream.AsyncWrite(pixels')
    }

let processImagesAsync() =
    printfn "processImagesAsync...";
    let tasks = [for i in 1 .. numImages -> processImageAsync(i)]
    Async.RunSynchronously (Async.Parallel tasks) |> ignore
    printfn "Funkcja processImagesAsync zakończyła pracę!"

System.Environment.CurrentDirectory <- Path.Combine(__SOURCE_DIRECTORY__, "temp")
makeImageFiles()

//Generowanie 200 rysunków o wymiarach 512x512... 
//Gotowe.
//
//val numImages : int = 200
//val size : int = 512
//val numPixels : int = 262144
//val makeImageFiles : unit -> unit
//val processImageRepeats : int = 20
//val transformImage : pixels:byte [] * imageNum:int32 -> byte []
//val processImageSync : i:int32 -> unit
//val processImagesSync : unit -> unit
//val processImageAsync : i:int32 -> Async<unit>
//val processImagesAsync : unit -> unit
//val it : unit = ()

#time "on"

//DO ZROBIENIA: postarać się wymusić zwalnianie zasobów przez GC.Collect().
processImagesSync()
processImagesAsync()

//--> Timing now on
//
//processImagesSync...
//...
//transformImage 198
//transformImage 199
//transformImage 200
//Real: 00:00:02.973, CPU: 00:00:03.681, GC gen0: 29, gen1: 29, gen2: 29
//val it : unit = ()

//processImagesSync...
//...
//transformImage 159
//transformImage 160
//transformImage 161
//System.IO.IOException: The process cannot access the file 'C:\...\Image161.done' because it is being used by another process.
//   at System.IO.__Error.WinIOError(Int32 errorCode, String maybeFullPath)
//   at System.IO.FileStream.Init(String path, FileMode mode, FileAccess access, Int32 rights, Boolean useRights, FileShare share, Int32 bufferSize, FileOptions options, SECURITY_ATTRIBUTES secAttrs, String msgPath, Boolean bFromProxy, Boolean useLongPath, Boolean checkHost)
//   at System.IO.FileStream..ctor(String path, FileMode mode, FileAccess access, FileShare share)
//   at FSI_0002.processImageSync(Int32 i) in C:\...\Script.fsx:line 301
//   at FSI_0002.processImagesSync() in C:\...\Script.fsx:line 307
//   at <StartupCode$FSI_0004>.$FSI_0004.main@() in C:\...\Script.fsx:line 344
//Stopped due to error

//processImagesAsync...
//...
//transformImage 199
//transformImage 198
//transformImage 200
//System.IO.IOException: The process cannot access the file 'C:\...\Image173.done' because it is being used by another process.
//   at System.IO.__Error.WinIOError(Int32 errorCode, String maybeFullPath)
//   at System.IO.FileStream.Init(String path, FileMode mode, FileAccess access, Int32 rights, Boolean useRights, FileShare share, Int32 bufferSize, FileOptions options, SECURITY_ATTRIBUTES secAttrs, String msgPath, Boolean bFromProxy, Boolean useLongPath, Boolean checkHost)
//   at System.IO.FileStream..ctor(String path, FileMode mode, FileAccess access, FileShare share)
//   at FSI_0003.processImageAsync@332-3.Invoke(Byte[] _arg2) in C:\...\Script.fsx:line 333
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.args@835-1.Invoke(a a)
//--- End of stack trace from previous location where exception was thrown ---
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.commit[a](Result`1 res)
//   at Microsoft.FSharp.Control.CancellationTokenOps.RunSynchronously[a](CancellationToken token, FSharpAsync`1 computation, FSharpOption`1 timeout)
//   at Microsoft.FSharp.Control.FSharpAsync.RunSynchronously[T](FSharpAsync`1 computation, FSharpOption`1 timeout, FSharpOption`1 cancellationToken)
//   at FSI_0003.processImagesAsync() in C:\...\Script.fsx:line 340
//   at <StartupCode$FSI_0006>.$FSI_0006.main@() in C:\...\Script.fsx:line 346
//Stopped due to error

//processImagesAsync...
//...
//transformImage 193
//transformImage 192
//transformImage 191
//processImagesAsync finished!
//Real: 00:00:00.874, CPU: 00:00:02.418, GC gen0: 9, gen1: 8, gen2: 8
//val it : unit = ()

#time "off"

let failingAsync = async { do failwith "fail" }
//val failingAsync : Async<unit>

Async.RunSynchronously failingAsync
//System.Exception: fail
//   at FSI_0012.failingAsync@403.Invoke(Unit unitVar) in C:\...\Script.fsx:line 403
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.callA@851.Invoke(AsyncParams`1 args)
// --- End of stack trace from previous location where exception was thrown ---
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.commit[a](Result`1 res)
//   at Microsoft.FSharp.Control.CancellationTokenOps.RunSynchronously[a](CancellationToken token, FSharpAsync`1 computation, FSharpOption`1 timeout)
//   at Microsoft.FSharp.Control.FSharpAsync.RunSynchronously[T](FSharpAsync`1 computation, FSharpOption`1 timeout, FSharpOption`1 cancellationToken)
//   at <StartupCode$FSI_0013>.$FSI_0013.main@() in C:\...\Script.fsx:line 406
//Stopped due to error

let failingAsyncs = [async {do failwith "fail A"}; async {do failwith "fail B"}]
//val failingAsyncs : Async<unit> list =
//  [Microsoft.FSharp.Control.FSharpAsync`1[Microsoft.FSharp.Core.Unit];
//   Microsoft.FSharp.Control.FSharpAsync`1[Microsoft.FSharp.Core.Unit]]

Async.RunSynchronously (Async.Parallel failingAsyncs)
//System.Exception: fail A
//   at FSI_0008.failingAsyncs@420-4.Invoke(Unit unitVar) in C:\...\Script.fsx:line 420
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.callA@851.Invoke(AsyncParams`1 args)
//--- End of stack trace from previous location where exception was thrown ---
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.commit[a](Result`1 res)
//   at Microsoft.FSharp.Control.CancellationTokenOps.RunSynchronously[a](CancellationToken token, FSharpAsync`1 computation, FSharpOption`1 timeout)
//   at Microsoft.FSharp.Control.FSharpAsync.RunSynchronously[T](FSharpAsync`1 computation, FSharpOption`1 timeout, FSharpOption`1 cancellationToken)
//   at <StartupCode$FSI_0009>.$FSI_0009.main@() in C:\...\Script.fsx:line 422
//Stopped due to error

Async.RunSynchronously (Async.Parallel failingAsyncs)
//System.Exception: fail B
//    at FSI_0008.failingAsyncs@420-5.Invoke(Unit unitVar) in C:\...\Script.fsx:line 420
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.callA@851.Invoke(AsyncParams`1 args)
//--- End of stack trace from previous location where exception was thrown ---
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.commit[a](Result`1 res)
//   at Microsoft.FSharp.Control.CancellationTokenOps.RunSynchronously[a](CancellationToken token, FSharpAsync`1 computation, FSharpOption`1 timeout)
//   at Microsoft.FSharp.Control.FSharpAsync.RunSynchronously[T](FSharpAsync`1 computation, FSharpOption`1 timeout, FSharpOption`1 cancellationToken)
//   at <StartupCode$FSI_0011>.$FSI_0011.main@() in C:\...\Script.fsx:line 434
//Stopped due to error

Async.RunSynchronously (Async.Catch failingAsync)
//val it : Choice<unit,exn> =
//  Choice2Of2
//    System.Exception: fail
//   at FSI_0012.failingAsync@403.Invoke(Unit unitVar) in C:\...\Script.fsx:line 403
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.callA@851.Invoke(AsyncParams`1 args)
//      {Data = dict [];
//       HResult = -2146233088;
//       HelpLink = null;
//       InnerException = null;
//       Message = "fail";
//       Source = "FSI-ASSEMBLY";
//       StackTrace = "   at FSI_0012.failingAsync@403.Invoke(Unit unitVar) in C:\...\Script.fsx:line 403
//   at Microsoft.FSharp.Control.AsyncBuilderImpl.callA@851.Invoke(AsyncParams`1 args)";
//       TargetSite = Microsoft.FSharp.Control.FSharpAsync`1[Microsoft.FSharp.Core.Unit] Invoke(Microsoft.FSharp.Core.Unit);}

type Agent<'T> = MailboxProcessor<'T>

let counter =
    new Agent<_>(fun inbox ->
        let rec loop n =
            async {printfn "n = %d, trwa oczekiwanie..." n
                   let! msg = inbox.Receive()
                   return! loop (n + msg)}
        loop 0)
//type Agent<'T> = MailboxProcessor<'T>
//val counter : Agent<int>

counter.Start()
//n = 0, trwa oczekiwanie...

counter.Post(1)
//n = 1, trwa oczekiwanie...

counter.Post(2)
//n = 3, trwa oczekiwanie...

counter.Post(1)
//n = 4, trwa oczekiwanie...


/// Wewnętrzny typ komunikatów agenta
type internal msg = Increment of int | Fetch of AsyncReplyChannel<int> | Stop

type CountingAgent() =
    let counter = MailboxProcessor.Start(fun inbox ->
		 // Stany maszyny stanowej do przetwarzania komunikatów
         let rec loop n =
             async {let! msg = inbox.Receive()
                    match msg with
                    | Increment m ->
						// Zwiększanie wartości i kontynuowanie pracy
                        return! loop(n + m)
                    | Stop ->
                        // Wyjście
                        return ()
                    | Fetch replyChannel  ->
						// Przekazanie odpowiedzi do kanału i kontynuowanie pracy
                        do replyChannel.Reply n
                        return! loop n}

		 // Początkowy stan maszyny stanowej do przetwarzania komunikatów
         loop(0))

    member a.Increment(n) = counter.Post(Increment n)
    member a.Stop() = counter.Post Stop
    member a.Fetch() = counter.PostAndReply(fun replyChannel -> Fetch replyChannel)

let counter = new CountingAgent()
//type internal msg =
//  | Increment of int
//  | Fetch of AsyncReplyChannel<int>
//  | Stop
//type CountingAgent =
//  class
//    new : unit -> CountingAgent
//    member Fetch : unit -> int
//    member Increment : n:int -> unit
//    member Stop : unit -> unit
//  end
//val counter : CountingAgent

counter.Increment(1)
//val it : unit = ()

counter.Fetch()
//val it : int = 1

counter.Increment(2)
//val it : unit = ()

counter.Fetch()
//val it : int = 3

counter.Stop()
//val it : unit = ()


type Message =
    | Message1
    | Message2 of int
    | Message3 of string

let agent =
    MailboxProcessor.Start(fun inbox ->
        let rec loop() =
            inbox.Scan(function
                | Message1 ->
                   Some (async {do printfn "Komunikat 1!"
                                return! loop()})
                | Message2 n ->
                   Some (async {do printfn "Komunikat 2!"
                                return! loop()})
                | Message3 _ ->
                   None)
        loop())

agent.Post(Message1);
agent.Post(Message2(100))
agent.Post(Message3("abc"))
agent.Post(Message2(100))
agent.CurrentQueueLength

//Komunikat 1!
//Komunikat 2!
//Komunikat 2!
//
//type Message =
//  | Message1
//  | Message2 of int
//  | Message3 of string
//val agent : MailboxProcessor<Message>
//val it : int = 4

open System.Collections.Generic
open System.Net
open System.IO
open System.Threading
open System.Text.RegularExpressions

let limit = 50
let linkPat = "href=\s*\"[^\"h]*(http://[^&\"]*)\""
let getLinks (txt:string) =
    [ for m in Regex.Matches(txt,linkPat)  -> m.Groups.Item(1).Value ]

// Typ pomagający ograniczyć liczbę aktywnych żądań sieciowych
type RequestGate(n:int) =
    let semaphore = new Semaphore(initialCount=n,maximumCount=n)
    member x.AsyncAcquire(?timeout) =
        async { 
            let! ok = Async.AwaitWaitHandle(semaphore,
                                            ?millisecondsTimeout=timeout)
            if ok then
               return
                 { new System.IDisposable with
                     member x.Dispose() =
                         semaphore.Release() |> ignore }
            else
               return! failwith "Nieudana próba zajęcia semafora" 
        }

// Bramka ograniczająca liczbę aktywnych żądań sieciowych
let webRequestGate = RequestGate(5)

// Pobieranie adresu URL i przekazywanie wyników do agenta urlCollector
let collectLinks (url:string) =
    async { 
        // Asynchroniczne żądanie sieciowe z globalną bramką
        let! html =
            async { 
                // Zajmowanie slotu z bramki webRequestGate; slot jest
                // zwalniany, gdy wartość holder wychodzi z zasięgu programu
                use! holder = webRequestGate.AsyncAcquire()

                let req = WebRequest.Create(url,Timeout=5)

                // Oczekiwanie na odpowiedź
                use! response = req.AsyncGetResponse()

                // Pobieranie strumienia z odpowiedzią
                use reader = new StreamReader(response.GetResponseStream())

                // Odczyt strumienia z odpowiedzią (uwaga — odbywa się synchronicznie)
                return reader.ReadToEnd() 
            }

        // Synchroniczne wyszukiwanie odsyłaczy
        let links = getLinks html

        // Synchroniczne informowanie o wynikach
        printfn "Zakończono odczyt %s. Liczba odsyłaczy: %d" url (List.length links)

        // Zadanie zostało wykonane
        return links 
    }

/// urlCollector to agent przyjmujący komunikaty w postaci adresów URL; tworzy
/// nowe zadania asynchroniczne, przekazujące komunikaty z powrotem do bieżącego obiektu
let urlCollector =
    MailboxProcessor.Start(fun self ->

		// To podstawowy stan agenta urlCollector
        let rec waitForUrl (visited : Set<string>) =

           async { 
               // Sprawdzanie ograniczenia
               if visited.Count < limit then

                   // Oczekiwanie na adres URL
                   let! url = self.Receive()
                   if not (visited.Contains(url)) then
                       // Uruchamianie nowego zadania dla nowego adresu URL; każde zadanie
                       // zapisuje odsyłacze i przekazuje je z powrotem do agenta urlCollector
                       do! Async.StartChild
                               (async { let! links = collectLinks url
                                        for link in links do
                                           self.Post link }) |> Async.Ignore

				   // Rekurencyjne wejście w stan oczekiwania
                   return! waitForUrl(visited.Add(url)) 
            }

        // To początkowy stan
        waitForUrl(Set.empty))

urlCollector.Post "http://news.google.com"

//val limit : int = 50
//val linkPat : string = "href=\s*"[^"h]*(http://[^&"]*)""
//val getLinks : txt:string -> string list
//type RequestGate =
//  class
//    new : n:int -> RequestGate
//    member AsyncAcquire : ?timeout:int -> Async<System.IDisposable>
//  end
//val webRequestGate : RequestGate
//val collectLinks : url:string -> Async<string list>
//val urlCollector : MailboxProcessor<string>
//val it : unit = ()
//
//Zakończono odczyt http://news.google.com. Liczba odsyłaczy: 181
//Zakończono odczyt http://www.gstatic.com/news-static/img/favicon.ico. Liczba odsyłaczy: 0 
//Zakończono odczyt http://www.cbc.ca/news/politics/military-suicide-afghanistan-mental-1.3312860. Liczba odsyłaczy: 99 
//Zakończono odczyt http://www.google.ca/preferences?hl=en. Liczba odsyłaczy: 3 
//Zakończono odczyt http://www.google.ca/preferences. Liczba odsyłaczy: 4 
//Zakończono odczyt http://www.cbc.ca/news/politics/parliamentary-budget-officer-trudeau-plans-1.3312757. Liczba odsyłaczy: 100 
//Zakończono odczyt http://www.google.ca/finance?tab=ne. Liczba odsyłaczy: 12 
//Zakończono odczyt http://www.metronews.ca/news/canada/2015/11/10/suicide-in-military-a-concern-those-at-risk-should-seek-help-says-vance.html. Liczba odsyłaczy: 69 
//Zakończono odczyt http://www.huffingtonpost.ca/2015/11/10/pbo-economic-outlook-deficit-housing_n_8521938.html. Liczba odsyłaczy: 336 
//Zakończono odczyt http://globalnews.ca/news/2331765/army-suicide-rate-3-times-higher-than-other-branches-of-canadian-military/. Liczba odsyłaczy: 103 
//Zakończono odczyt http://www.blogger.com/?tab=nj. Liczba odsyłaczy: 1 
//Zakończono odczyt http://ckom.com/article/288763/trudeau-government-facing-bigger-baseline-deficits-amid-weaker-economy-pbo. Liczba odsyłaczy: 15 
//Zakończono odczyt http://indianexpress.com/article/world/world-news/russia-to-deploy-new-weapons-to-counter-us-missile-shield/. Liczba odsyłaczy: 111 
//Zakończono odczyt http://www.reuters.com/article/2015/11/10/us-mideast-crisis-syria-draft-idUSKCN0SZ2F720151110. Liczba odsyłaczy: 103 
//Zakończono odczyt http://www.denverpost.com/opinion/ci_29099212/dobbs-why-putin-doesnt-want-plane-crash-have. Liczba odsyłaczy: 56 
//Zakończono odczyt http://www.youtube.com/?tab=n1. Liczba odsyłaczy: 0 
//Zakończono odczyt http://www.bustle.com/articles/122910-whos-returning-to-star-wars-the-force-awakens-features-lots-of-familiar-faces. Liczba odsyłaczy: 1 
//Zakończono odczyt http://www.mapleridgenews.com/community/344927012.html. Liczba odsyłaczy: 52 
//Zakończono odczyt http://www.dailymail.co.uk/wires/ap/article-3312876/Russia-calls-new-Syrian-constitution-18-months.html. Liczba odsyłaczy: 22 
//Zakończono odczyt http://www.stuff.co.nz/entertainment/film/73920909/star-wars-rebel-alliance-freedom-fighters-or-terrorists. Liczba odsyłaczy: 52 
//Zakończono odczyt http://www.cbc.ca/news/canada/toronto/toronto-police-college-park-assaults-arrest-1.3312980. Liczba odsyłaczy: 89 
//Zakończono odczyt http://www.torontosun.com/2015/11/10/cineplex-expects-huge-profits-from-the-force-of-star-wars-other-big-hits. Liczba odsyłaczy: 305 
//Zakończono odczyt http://www.reuters.com/article/2015/11/10/us-mideast-crisis-syria-idUSKCN0SZ15E20151110. Liczba odsyłaczy: 103 
//Zakończono odczyt http://www.latimes.com/world/middleeast/la-fg-syria-shelling-20151110-story.html. Liczba odsyłaczy: 13 
//Zakończono odczyt http://www.torontosun.com/2015/11/10/lest-we-forget-why-we-are-free. Liczba odsyłaczy: 310 
//Zakończono odczyt http://www.huffingtonpost.com/entry/netanyahu-center-for-american-progress_564283a8e4b060377346d5a1. Liczba odsyłaczy: 54 
//Zakończono odczyt http://www.jpost.com/Israel-News/Study-84-percent-of-Israelis-say-they-wouldnt-emigrate-432638. Liczba odsyłaczy: 22 
//Zakończono odczyt http://www.telegraph.co.uk/news/worldnews/middleeast/syria/11987256/Russia-and-Iran-backed-offensive-helps-regime-break-Isils-two-year-siege-on-Syrian-airbase.html. Liczba odsyłaczy: 99 
//Zakończono odczyt http://www.bloomberg.com/politics/articles/2015-11-11/netanyahu-works-to-assuage-democrats-after-his-visit-with-obama. Liczba odsyłaczy: 71 
//Zakończono odczyt http://timesofindia.indiatimes.com/life-style/home-garden/Wide-range-of-ornate-diyas-light-up-homes-this-Diwali/articleshow/49687329.cms. Liczba odsyłaczy: 89 
//Zakończono odczyt http://www.business-standard.com/article/news-ians/trinidad-celebrates-diwali-in-fine-style-115111100061_1.html. Liczba odsyłaczy: 28 
//Zakończono odczyt http://www.ibtimes.com/what-diwali-2015-festival-light-celebrates-good-defeating-evil-2173793. Liczba odsyłaczy: 66 
//Zakończono odczyt http://www.torontosun.com/2015/11/10/arrest-made-in-college-park-assault-rampage. Liczba odsyłaczy: 307 
//Zakończono odczyt http://www.cbc.ca/news/technology/betamax-death-sony-1.3312556. Liczba odsyłaczy: 91 
//Zakończono odczyt http://www.thestar.com/business/2015/11/10/40-years-on-sony-finally-kills-betamax.html. Liczba odsyłaczy: 171 
//Zakończono odczyt http://tribune.com.pk/story/988986/festival-of-lights-diwali-brings-citizens-together/. Liczba odsyłaczy: 105 
//Zakończono odczyt http://www.ctvnews.ca/sci-tech/sony-to-stop-selling-betamax-tapes-in-2016-yes-they-still-exist-1.2652002. Liczba odsyłaczy: 270 
//Zakończono odczyt http://www.theverge.com/2015/11/9/9703004/sony-is-finally-killing-betamax. Liczba odsyłaczy: 199 
//Zakończono odczyt http://toronto.ctvnews.ca/suspect-in-custody-after-violent-assaults-in-college-park-1.2651908. Liczba odsyłaczy: 202 
//Zakończono odczyt http://www.fortmcmurraytoday.com/2015/11/09/notley-focusing-on-cleaner-pipeline-plan. Liczba odsyłaczy: 130 
//Zakończono odczyt http://www.theprovince.com/abusive+pimp+handed+year+sentence+luring+vulnerable+teens+into+prostitution/11507780/story.html. Liczba odsyłaczy: 157 
//Zakończono odczyt http://www.cknw.com/2015/11/10/23-years-sentence-for-first-person-in-b-c-ever-charged-with-human-trafficking/. Liczba odsyłaczy: 74 
//Zakończono odczyt http://calgaryherald.com/news/national/alberta-waiting-on-ottawa-before-committing-to-syrian-refugees. Liczba odsyłaczy: 279 
//Zakończono odczyt http://www.ctvnews.ca/canada/b-c-man-who-trafficked-teen-girls-sentenced-to-23-years-in-prison-1.2651729. Liczba odsyłaczy: 272 
//Zakończono odczyt http://www.castanet.net/news/Kamloops/151555/Medical-issue-triggers-crash. Liczba odsyłaczy: 84 
//Zakończono odczyt http://www.kamloopsthisweek.com/walmart-security-guard-stabbed-19-year-old-man-in-custody/. Liczba odsyłaczy: 177 
//Zakończono odczyt http://www.ctvnews.ca/canada/wounded-afghan-soldier-trevor-greene-receives-honorary-uvic-degree-1.2652110. Liczba odsyłaczy: 273 
//Zakończono odczyt http://globalnews.ca/news/2331292/suspected-shoplifter-stabs-store-employee-in-kamloops/. Liczba odsyłaczy: 81
//Zakończono odczyt http://www.timescolonist.com/wounded-soldier-trevor-greene-receives-honorary-uvic-degree-1.2107892. Liczba odsyłaczy: 57 
//Zakończono odczyt http://aranews.net/2015/11/syrian-regime-troops-break-isis-siege-of-major-air-base-in-aleppo/. Liczba odsyłaczy: 268 

open System.Threading
open System

// Równoległe inicjowanie tablicy z użyciem wszystkich dostępnych procesorów
// Zauważ, że ten prosty mechanizm nie umożliwia anulowania operacji
let parallelArrayInit n f = 
   let currentLine = ref -1
   let res = Array.zeroCreate n
   let rec loop () = 
       let y = Interlocked.Increment(currentLine)
       if y < n then res.[y] <- f y; loop()

   // Uruchamianie odpowiedniej liczby zadań ― po jednym na każdy fizyczny procesor
   Async.Parallel [for i in 1 .. Environment.ProcessorCount -> async {do loop()}]
      |> Async.Ignore 
      |> Async.RunSynchronously

   res

let rec fib x = if x < 2 then 1 else fib (x - 1) + fib (x - 2)

parallelArrayInit 25 (fun x -> fib x)
//val parallelArrayInit : n:int -> f:(int -> 'a) -> 'a []
//val fib : x:int -> int
//val it : int [] =
//  [|1; 1; 2; 3; 5; 8; 13; 21; 34; 55; 89; 144; 233; 377; 610; 987; 1597; 2584;
//    4181; 6765; 10946; 17711; 28657; 46368; 75025|]

open System.Threading
let t = new Thread(ThreadStart(fun _ ->
                printfn "Wątek %d: Witaj" Thread.CurrentThread.ManagedThreadId));
t.Start();
printfn "Wątek %d: Oczekiwanie!" Thread.CurrentThread.ManagedThreadId
t.Join();
printfn "Gotowe!"

//val t : Thread
//Wątek 1: Oczekiwanie!
//Wątek 10: Witaj
//Gotowe!

open System.Threading
open System.Threading.Tasks

let doSome1Thing() = 
    printfn "Kod robi jedną rzecz"
    System.Threading.Thread.Sleep 100
    printfn "Kod zrobił pierwszą rzecz"

let doSome2Thing(_ : CancellationToken) = 
    printfn "Kod robi drugą rzecz"
    System.Threading.Thread.Sleep 100
    printfn "Kod zrobił drugą rzecz"

let doSome3Thing(ct : CancellationToken) = 
    printfn "Kod robi trzecią rzecz"
    ct.ThrowIfCancellationRequested() 
    System.Threading.Thread.Sleep 100
    ct.ThrowIfCancellationRequested() 
    printfn "Kod zrobił trzecią rzecz"

let cts = new CancellationTokenSource()

let task1 = Task.Run (fun () -> doSome1Thing())
let task2 = Task.Run (fun () -> doSome2Thing(cts.Token), cts.Token)
let task3 = Task.Run (fun () -> doSome3Thing(cts.Token), cts.Token)

cts.Cancel()
//Kod robi jedną rzecz
//Kod robi drugą rzecz
//Kod robi trzecią rzecz
//
//val doSome1Thing : unit -> unit
//val doSome2Thing : System.Threading.CancellationToken -> unit
//val doSome3Thing : ct:System.Threading.CancellationToken -> unit
//val cts : System.Threading.CancellationTokenSource
//val task1 : System.Threading.Tasks.Task
//val task2 :
//  System.Threading.Tasks.Task<unit * System.Threading.CancellationToken>
//val task3 :
//  System.Threading.Tasks.Task<unit * System.Threading.CancellationToken>
//val it : unit = ()
//
//Kod zrobił pierwszą rzecz
//Kod zrobił drugą rzecz



type MutablePair<'T, 'U>(x : 'T, y : 'U) =
    let mutable currentX = x
    let mutable currentY = y
    member p.Value = (currentX, currentY)
    member p.Update(x, y) =
		// Sytuacja wyścigu - ta para aktualizacji nie jest atomowa
        currentX <- x
        currentY <- y

let p = new MutablePair<_, _>(1, 2)
do Async.Start (async {do (while true do p.Update(10, 10))})
do Async.Start (async {do (while true do p.Update(20, 20))})

open System.Threading
let lock (lockobj : obj) f  =
    Monitor.Enter lockobj
    try
        f()
    finally
        Monitor.Exit lockobj

do Async.Start (async {do (while true do lock p (fun () -> p.Update(10, 10)))})
do Async.Start (async {do (while true do lock p (fun () -> p.Update(20, 20)))})
//type MutablePair<'T,'U> =
//  class
//    new : x:'T * y:'U -> MutablePair<'T,'U>
//    member Update : x:'T * y:'U -> unit
//    member Value : 'T * 'U
//  end
//val p : MutablePair<int,int>
//val lock : lockobj:obj -> f:(unit -> 'a) -> 'a
//val it : unit = ()

open System.Threading

let readLock (rwlock : ReaderWriterLock) f  =
  rwlock.AcquireReaderLock(Timeout.Infinite)
  try
      f()
  finally
      rwlock.ReleaseReaderLock()

let writeLock (rwlock : ReaderWriterLock) f  =
  rwlock.AcquireWriterLock(Timeout.Infinite)
  try
      f()
      Thread.MemoryBarrier()
  finally
      rwlock.ReleaseWriterLock()

type MutablePair<'T, 'U>(x : 'T, y : 'U) =
    let mutable currentX = x
    let mutable currentY = y
    let rwlock = new ReaderWriterLock()
    member p.Value =
        readLock rwlock (fun () ->
            (currentX, currentY))
    member p.Update(x, y) =
        writeLock rwlock (fun () ->
            currentX <- x
            currentY <- y)
//val readLock :
//  rwlock:System.Threading.ReaderWriterLock -> f:(unit -> 'a) -> 'a
//val writeLock :
//  rwlock:System.Threading.ReaderWriterLock -> f:(unit -> unit) -> unit
//type MutablePair<'T,'U> =
//  class
//    new : x:'T * y:'U -> MutablePair<'T,'U>
//    member Update : x:'T * y:'U -> unit
//    member Value : 'T * 'U
//  end

let () = ()
let () = 1 |> ignore
let 1 = 1
//warning FS0025: Incomplete pattern matches on this expression. For example, the value '0' may indicate a case not covered by the pattern(s).