define([
	'libs/text!tpl/application.html'
], function (applicationTpl){
	return ApplicationView = Backbone.View.extend({
		el: "#content",
		template: applicationTpl,
		events: {
			'click #update': 'update'
		},
		initialize: function() {
		},
		successErrorOps: {
			success: function (model) {
				app.alertsView.success("Uaktualniono!");
			},
			error: function(response){
				app.alertsView.error(response);
		}},
		get: function() {
			this.model = new ApplicationModel();
			this.model.bind('change', this.render, this);
			this.model.fetch({
				xhrFields: {
			      withCredentials: true
			   },
			success: function() {
				app.alertsView.success("Informacje zostały zapisane, ale w celu zatwierdzenia członkostwa musisz zgodzić się na miesięczną opłatę i podać numer karty kredytowej. Jeżeli to zrobisz, Twoja aplikacja zostanie wysłana! Poczekaj na e-mail wraz z potwierdzeniem członkostwa. Na tę stronę możesz powrócić w dowolnej chwili i uaktualnić podane informacje. ");
				console.log('s');

			},
			error: function(response) {
				console.log('Błąd!');
				app.alertsView.error(response);
				app.navigate('#login', true);
			}
			});
		},
		update: function(){
			applicationView = this
			// console.log(this.model);
			var updateData = this.$el.find('form').toObject();
			for (var key in updateData) {
				if (updateData[key]) {
					this.model.attributes[key] = updateData[key];
				}
			}
			console.log(this.model);
			this.model.save({}, applicationView.successErrorOps);
		},
		render: function() {
			var applicationView = this
			this.$el.html(_.template(this.template, {attr:this.model.attributes}));
			var handler = StripeCheckout.configure({
			   key: this.model.get('stripePub'),
			   image: '/img/webapplog-logo.png',

		    token: function(token) {

		      applicationView.model.set('stripeToken', token).save({}, applicationView.successErrorOps);
		      applicationView.model.set('isStripeToken', true)
		      // Przenieś w celu ukrycia/wyświetlenia i szablonów.
					$('.stripe-button').fadeOut().after('<span> Dodano kartę kredytową/debetową.</span>').after('<i class="icon-ok"></i>')
		    }
		  });

		  $('.stripe-button').on('click', function(e) {
		    // Przejście do kasy i wyświetlenie innych opcji.
		    handler.open({
			    src: 'https://checkout.stripe.com/checkout.js',
			    class: 'stripe-button',
			    type: 'text/javascript',
			    currency: 'USD',
			    amount: '299',
			    name: 'Membership',
			    description: 'Opłata członkowska wynosi 2.99 USD miesięcznie i pokrywa koszty hostingu oraz obsługi.',
			    email: applicationView.model.get('email')
		    });
		    e.preventDefault();
		  });

		  // Zamknięcie na stronie nawigacji.
		  $(window).on('popstate', function() {
		    handler.close();
		  });

		}
	});
})