var cluster = require('cluster');
var numCPUs = require('os').cpus().length;
var express = require('express');

if (cluster.isMaster) {
  console.log ('Utworzenie %s procesów roboczych na podstawie głównego.', numCPUs);
  for (var i = 0; i < numCPUs; i++) {
    cluster.fork();
  }
  cluster.on('online', function(worker) {
    console.log ('Proces roboczy ma identyfikator %s.', worker.process.pid);
  });
  cluster.on('exit', function(worker, code, signal) {
    console.log('Proces roboczy %s został zamknięty.', worker.process.pid );
  });
} else if (cluster.isWorker) {
  var port = 3000;
  console.log('Proces roboczy (%s) nasłuchuje na http://localhost:%s.', cluster.worker.process.pid, port);
  var app = express();
  app.get('*', function(req, res) {
    res.send(200, 'Klaster ' + cluster.worker.process.pid + ' udzielił odpowiedzi.\n');
  });
  app.listen(port);
}
