var app = require('../server').app,
  assert = require('assert'),
  request = require('superagent');
// http = require('support/http');

var user1 = request.agent();
var port = 'http://localhost:' + app.get('port');

var adminUser = {
  email: 'admin-test@test.com',
  password: 'admin-test'
};

app.listen(app.get('port'), function() {
  console.log('Serwer Express nasłuchuje na porcie ' + app.get('port'));
});

suite('Test root', function() {
  setup(function(done) {
    console.log('setup');

    done();
  });

  test('Sprawdzenie /', function(done) {
    request.get('http://localhost:3000').end(function(res) {
      assert.equal(res.status, 200);
      done();
    });
  });
  test('Sprawdzenie /api/profile', function(done) {
    request.get('http://localhost:' + app.get('port') + '/api/profile').end(function(res) {
      assert.equal(res.status, 500);
      done();
    });
  });
  test('Sprawdzenie /api/users', function(done) {
    user1.get('http://localhost:' + app.get('port') + '/api/users').end(function(res) {
      assert.equal(res.status, 500);
      // console.log(res.text.length);
      done();
    });
    // done();
  });
  test('Sprawdzenie /api/posts', function(done) {
    user1.get('http://localhost:' + app.get('port') + '/api/posts').end(function(res) {
      assert.equal(res.status, 500);
      // console.log(res.text.length);
      done();
    });
    // done();
  });
  teardown(function(done) {
    console.log('teardown');
    done();
  });

});

suite('Test logowania.', function() {
  setup(function(done) {
    console.log('setup');
    done();
  });
  test('login', function(done) {
    user1.post('http://localhost:3000/api/login').send(adminUser).end(function(res) {
      assert.equal(res.status, 200);
      done();
    });

  });
  test('Sprawdzenie /api/profile', function(done) {
    user1.get('http://localhost:' + app.get('port') + '/api/profile').end(function(res) {
      assert.equal(res.status, 200);
      // console.log(res.text.length);
      done();
    });
    // done();
  });
  test('Sprawdzenie /api/users', function(done) {
    user1.get('http://localhost:' + app.get('port') + '/api/users').end(function(res) {
      assert.equal(res.status, 200);
      // console.log(res.text);
      done();
    });
    // done();
  });
  test('Sprawdzenie /api/posts', function(done) {
    user1.get('http://localhost:' + app.get('port') + '/api/posts').end(function(res) {
      assert.equal(res.status, 200);
      // console.log(res.text.length);
      done();
    });
    // done();
  });

  teardown(function(done) {
    console.log('teardown');
    done();
  });

});
suite('Kontrola użytkownika', function() {
  var user2 = {
    firstName: 'Bob',
    lastName: 'Dilan',
    displayName: 'Bob Dilan',
    email: '2@2.com'
  };
  suiteSetup(function(done) {
    user1
      .post('http://localhost:3000/api/login')
      .send(adminUser)
      .end(function(res) {
        assert.equal(res.status, 200);
        // done();
        }
      );
    user1.get('http://localhost:' + app.get('port') + '/api/profile').end(function(res) {
      assert.equal(res.status, 200);
      // console.log(res.text.length);
      // done();
    });

    done();
  })

  test('Nowy użytkownik POST /api/users', function(done) {
    user1.post(port + '/api/users')
      .send(user2)
      .end(function(res) {
        assert.equal(res.status, 200);
        // console.log(res.text.length);
        user2 = res.body;
        // console.log(user2)
        done();
      })
  });
  test('Pobranie listy użytkownika i sprawdzenie nowego użytkownika GET /api/users', function(done) {
    user1.get('http://localhost:' + app.get('port') + '/api/users').end(function(res) {
      assert.equal(res.status, 200);
      // console.log(res.body)
      var user3 = res.body.filter(function(el, i, list) {
        return (el._id == user2._id);
      });
      assert(user3.length === 1);
      // assert(res.body.indexOf(user2)>-1);
      // console.log(res.body.length)
      done();
    })
  });
  test('Zatwierdzenie użytkownika: PUT /api/users/' + user2._id, function(done) {
    assert(user2._id != '');
    user1.put(port + '/api/users/' + user2._id)
      .send({
        approved: true
      })
      .end(function(res) {
        assert.equal(res.status, 200);
        // console.log(res.text.length);
        assert(res.body.approved);
        user1.get(port + '/api/users/' + user2._id).end(function(res) {
          assert(res.status, 200);
          assert(res.body.approved);
          done();
        })

      })
  });
  test('Zbanowany użytkownik: PUT /api/users/' + user2._id, function(done) {
    assert(user2._id != '');
    user1.put(port + '/api/users/' + user2._id)
      .send({
        banned: true
      })
      .end(function(res) {
        assert.equal(res.status, 200);
        // console.log(res.text.length);
        assert(res.body.banned);
        user1.get(port + '/api/users/' + user2._id).end(function(res) {
          assert(res.status, 200);
          assert(res.body.banned);
          done();
        })

      })
  });
  test('Promocja użytkownika: PUT /api/users/' + user2._id, function(done) {
    assert(user2._id != '');
    user1.put(port + '/api/users/' + user2._id)
      .send({
        admin: true
      })
      .end(function(res) {
        assert.equal(res.status, 200);
        // console.log(res.text.length);
        assert(res.body.admin);
        user1.get(port + '/api/users/' + user2._id).end(function(res) {
          assert(res.status, 200);
          assert(res.body.admin);
          done();
        })

      })
  });
  test('Usunięcie użytkownika: DELETE /api/users/:id', function(done) {
    assert(user2._id != '');
    user1.del(port + '/api/users/' + user2._id)
      .end(function(res) {
        assert.equal(res.status, 200);
        // console.log('id:' + user2._id)
        user1.get(port + '/api/users').end(function(res) {
          assert.equal(res.status, 200);
          var user3 = res.body.filter(function(el, i, list) {
            return (el._id === user2._id);
          });
          // console.log('***');
          // console.warn(user3);
          assert(user3.length === 0);
          done();
        });
      });


  });
});
// app.close();
// console.log(app)