var express = require('express');
var path = require('path');
var favicon = require('static-favicon');
var logger = require('morgan');
var cookieParser = require('cookie-parser');
var bodyParser = require('body-parser');

var routes = require('./routes/index');
var users = require('./routes/users');

var app = express();

// Konfiguracja silnika widoku.
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

app.use(favicon());
app.use(logger('dev'));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded());
app.use(cookieParser());
app.use(require('less-middleware')(path.join(__dirname, 'public')));
app.use(express.static(path.join(__dirname, 'public')));

app.use('/', routes);
app.use('/users', users);

/// Przechwycenie błędu 404 i przekazanie go procedurze obsługi błędów.
app.use(function(req, res, next) {
    var err = new Error('Nie znaleziono.');
    err.status = 404;
    next(err);
});

// Procedury obsługi błędów.

// Procedura obsługi błędów dla środowiska programistycznego.
// Wyświetlenie stosu wywołań.
if (app.get('env') === 'development') {
    app.use(function(err, req, res, next) {
        res.status(err.status || 500);
        res.render('error', {
            message: err.message,
            error: err
        });
    });
}

// Procedura obsługi błędów dla środowiska produkcyjnego.
// Bez wyświetlenia stosu wywołań.
app.use(function(err, req, res, next) {
    res.status(err.status || 500);
    res.render('error', {
        message: err.message,
        error: {}
    });
});


module.exports = app;
