package main

import (
	"encoding/json"
	"fmt"
	"io"
	"log"
	"net"
	"sync"
)

// Request reprezentuje żądanie jsonrpc2
type Request struct {
	Jsonrpc string      `json:"jsonrpc"`
	Method  string      `json:"method"`
	Params  interface{} `json:"params"`
	ID      uint64      `json:"id"`
}

// ReadIPC wczytuje dane z gniazda
func ReadIPC(r io.Reader, wg *sync.WaitGroup) {
	//Bufor 20KB
	buf := make([]byte, 20*1024)
	n, err := r.Read(buf[:])
	if err != nil {
		log.Fatal("Odczyt z gniazda jest niemożliwy", err)
	}
	fmt.Println("Odpowiedź węzła Ethereum: ", string(buf[0:n]))
	wg.Done()
}

func main() {
	var wg sync.WaitGroup
	socketfile := "/home/younix/testnet/chaindata/geth.ipc"

	// Tworzenie żądania
	params := make([]int, 0)
	request := &Request{
		Jsonrpc: "2.0",
		Method:  "eth_blockNumber",
		Params:  params,
		ID:      12345,
	}

	// Przekazywanie struktury do łańcucha znaków w formacie json
	strRequest, err := json.Marshal(&request)
	if err != nil {
		log.Fatal("Kodownaie żądania niemożliwe", err)
	}

	// Wywołanie gniazda
	ipc, err := net.Dial("unix", socketfile)
	if err != nil {
		log.Fatal("Połączenie się z gniazdem uniksowym jest niemożliwe", err)
	}
	defer ipc.Close()

	// Oczekiwanie na przychodzące komunikaty
	wg.Add(1)
	go ReadIPC(ipc, &wg)

	// Zapis danych do gniazda uniksowego
	fmt.Println("Wywołanie: ", request.Method)
	_, err = ipc.Write(strRequest)
	if err != nil {
		log.Fatal("Zapis danych do gniazda uniksowego jest niemożliwy", err)
	}

	// Oczekiwanie na odpowiedź
	wg.Wait()
}
