# Zdecentralizowana aplikacja do tworzenia aukcji w Ethereum

Ten projekt ma implementować podstawowe funkcje platformy aukcyjnej w Ethereum.

## Wymagania

![Auction Diagram](auction_diagram.png)

Aplikacja powinna być zdecentralizowana i korzystać ze stosu narzędzi z Ethereum:

1. Inteligentne kontrakty z logiką biznesową (aukcje, oferty, zwracanie środków i przekazywanie własności)
2. Swarm służy do składowania danych (grafiki i metadanych)
3. Whisper służy do przekazywania wiadomości w modelu P2P (w chatroomach)

### Repozytorium tokenów deed
Zarządzanie niewymiennymi tokenami dzięki implementacji repozytoriów zasobów/tokenów/tokenów deed przechowującego
unikatowe zasoby/tokeny/tokeny deed.

#### ERC: Non-fungible Token Standard #721 (NFT)
Zobacz odsyłacz: 
https://github.com/ethereum/eips/issues/721

### Repozytorium aukcji

Repozytorium aukcji MUSI działać jak dom aukcji o następujących funkcjach:

- Przechowywanie zasobów/tokenów/tokenów deed wystawianych na aukcji (ERC721 Ownership by smart contract)
- Umożliwianie użytkownikom składania ofert na aukcjach
- Śledzenie aukcji/ofert/własności
- Przekazywanie własności zasobu/tokenu/tokenu deed zwycięzcy aukcji
- Przekazywanie środków do twórcy aukcji, jeśli zakończno aukcję i jest przynajmniej jeden zwycięzca
- Anulowanie aukcji i obsługa zwrotu środków
- Interfejs użytkownika do wykonywania opisanych operacji

### Front-end: Vuejs2.x + Vuetify

Front-end opracowano za pomocą platformy do tworzenia dynamicznych interfejsów użytkownika z integracją 
z platformą Vuetify (jest ona zgodna ze stylem Material Design Google'a)

## Implementacja/przepływ danych

#### 1. Rejestrowanie tokenu ERC721 w repozytorium tokenów deed aplikacji

Repozytorium tokenów deed jest używane w projekcie do przechowywania tokenów powiązanych z metadanymi. Token deed jest rejestrowany
w wyniku nadania mu unikatowego identyfikatora i dołączenia metadanych (TokenURI). To metadane sprawiają, że poszczególne tokeny
są ważne lub cenne.

#### 2. Przekazywanie własności tokena deed do repozytorium aukcji (domu aukcyjnego)

Dom aukcyjny musi zweryfikować, że dany token deed należy do twórcy aukcji. Dlatego przed utworzeniem aukcji właściciel powinien przekazać
własność tokenu deed na adres inteligentnego kontraktu repozytorium aukcji.

#### 3. Tworzenie aukcji dotyczącej tokenu deed

Tworzenie aukcji to prosty proces wprowadzania szczegółów aukcji takich jak nazwa, cena wyjściowa, data zakończenia itd. Ważne jest
powiązanie tokenu deed z aukcją.

#### 4. Składanie ofert

Oferty może składać każdy oprócz twórcy aukcji. Złożenie oferty oznacza, że wcześniejsi licytujący otrzymują zwrot środków i dodawana
jest nowa oferta. Oto wymogi dotyczące ofert:
1. Aukcja nie wygasła
2. Licytujący nie jest twórca aukcji
3. Oferta jest wyższa niż aktualna lub cena wyjściowa (jeśli nie ma jeszcze żadnych ofert)

#### 5. Zwrot środków

Jeśli aukcja została anulowana, repozytorium aukcji MUSI przekazać własność zasobu/tokenu/tokenu deed z powrotem do twórcy aukcji i zwrócić
środki licytującym (jeśli tacy istnieją).

#### 5. Zwycięzca aukcji

Jeśli ktoś wygrał aukcję, zasób/token/token deed jest przekazywany do zwycięzcy, a oferowana kwota trafia do twórcy aukcji.

