package com.titan.access;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.List;

import com.titan.domain.*;

@Stateless
public class DataAccessBean implements DataAccessRemote
{
   @PersistenceContext private EntityManager manager;
    
   public void initializeDatabase()
   {
      Person p = new Person();
      p.setFirstName("Bartosz");
      p.setLastName("Biernacki");
      manager.persist(p);

      Customer cust = new Customer();
      cust.setFirstName("Sebastian");
      cust.setLastName("Libicki");
      cust.setStreet("ul. Krzywa");
      cust.setCity("Niepoomice");
      cust.setState("Maopolskie");
      cust.setZip("12-034");
      manager.persist(cust);

      Employee employee = new Employee();
      employee.setFirstName("Gerard");
      employee.setLastName("Kikut");
      employee.setStreet("ul. Mieszka I");
      employee.setCity("Antonin");
      employee.setState("Wielkopolskie");
      employee.setZip("62-431");
      employee.setEmployeeId(15);
      manager.persist(employee);

   }

   public List findAllPersons()
   {
      return manager.createQuery("FROM Person p").getResultList();
   }
}
