package com.titan.clients;

import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

import com.titan.domain.*;

public class Client1
{
   public static void main(String[] args) throws Exception 
   {
      EntityManagerFactory factory =
         Persistence.createEntityManagerFactory("titan");
      try 
      {
         Customer cust = createCustomerAddress(factory);
         createCreditCard(factory, cust);
      } 
      finally 
      {
         factory.close();
      }
   }

   public static Customer createCreditCard(
              EntityManagerFactory factory, Customer cust)
   {
      CreditCard card = new CreditCard();
      card.setExpirationDate(new java.util.Date());
      card.setNumber("4444-4444-4444-4444");
      card.setNameOnCard("Wojciech Biernacki");
      card.setCreditOrganization("Bank Kredytowy");
      card.setCustomer(cust);

      EntityManager manager = factory.createEntityManager();
      try {
         manager.getTransaction().begin();
         manager.persist(card);
         manager.getTransaction().commit();

         // Wykazuje, e metoda card.getCustomer() zwraca warto null.

         manager.clear();
         CreditCard cardCopy = manager.find(CreditCard.class, card.getId());
         System.out.println("Powinnimy otrzyma warto null: " + cardCopy.getCustomer());

         manager.getTransaction().begin();
         System.out.println("Ustawiamy waciwo po stronie wacicielskiej relacji.");
         Customer custCopy = manager.find(Customer.class, cust.getId());
         custCopy.setCreditCard(cardCopy);
         manager.getTransaction().commit();

         manager.clear();
         cardCopy = manager.find(CreditCard.class, card.getId());
         System.out.println("Powinnimy otrzyma kopi encji Customer: " +
                             cardCopy.getCustomer().getFirstName());
      }
      finally
      {
         manager.close();
      }
      return cust;
   }

   public static Customer createCustomerAddress(EntityManagerFactory factory) 
   {
      System.out.println("Create 1st Customer");
      Customer cust = new Customer();
      cust.setFirstName("Bill");
      cust.setLastName("Burke");
      Address address = new Address();
      address.setStreet("Beacon Street");
      address.setCity("Boston");
      address.setState("MA");
      address.setZip("02115");
      cust.setAddress(address);

      EntityManager manager = factory.createEntityManager();
      try
      {
         manager.getTransaction().begin();
         manager.persist(cust);
         manager.getTransaction().commit();
      }
      finally
      {
         manager.close();
      }
      System.out.println("Address was also persisted with auto-generated key: " 
                         + address.getId());
      System.out.println("Return detached Customer instance: " + cust.getId());
      return cust;
   }
}
