package com.titan.clients;

import com.titan.travelagent.TravelAgentRemote;
import com.titan.travelagent.ExtendedPersistenceContextRemote;
import com.titan.travelagent.TransactionPersistenceContextRemote;
import com.titan.domain.Cabin;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.NamingException;

import javax.rmi.PortableRemoteObject;

public class Client_2
{
    public static void main(String [] args) 
    {
        try 
	{
            Context jndiContext = getInitialContext();
            Object ref = jndiContext.lookup("TravelAgentBean/remote");
            TravelAgentRemote dao = (TravelAgentRemote)ref;


            ref = jndiContext.lookup("TransactionPersistenceContextBean/remote");
            TransactionPersistenceContextRemote txBean = (TransactionPersistenceContextRemote)ref;

	    Cabin fetchedCabin = dao.findCabin(1);
            int oldBedCount = fetchedCabin.getBedCount();

	    System.out.println("Wykorzystujemy stanowy komponent sesyjny z kontekstem utrwalania o zasigu transakcyjnym.");
	    txBean.setCabin(1);
	    txBean.updateBedCount(5);

	    fetchedCabin = dao.findCabin(1);
	    System.out.println("Liczba ek w kajucie nadal bdzie wynosia " + oldBedCount + ": " + fetchedCabin.getBedCount( ));

	    System.out.println("Wykorzystujemy stanowy komponent sesyjny z rozszerzonym kontekstem utrwalania.");

            ref = jndiContext.lookup("ExtendedPersistenceContextBean/remote");
            ExtendedPersistenceContextRemote extendedBean = (ExtendedPersistenceContextRemote)ref;


	    extendedBean.setCabin(1);
	    extendedBean.updateBedCount(5);

	    fetchedCabin = dao.findCabin(1);
	    System.out.println("Liczba ek w kajucie bdzie wynosia 5: " + fetchedCabin.getBedCount());

	    // kod czyszczcy
	    txBean.remove();
	    extendedBean.remove();
        } 
        catch (javax.naming.NamingException ne)
        {
	    ne.printStackTrace();
	}
    }

    public static Context getInitialContext() 
        throws javax.naming.NamingException 
    {
        return new javax.naming.InitialContext();
    }
}
