package com.titan.clients;

import javax.jms.MapMessage;
import javax.jms.Session;
import javax.jms.ConnectionFactory;
import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Queue;
import javax.jms.MessageProducer;

import javax.naming.Context;
import javax.naming.InitialContext;

import java.util.Date;

import com.titan.processpayment.*;
import com.titan.access.DataAccess;


public class JmsClient_ReservationProducer
{
   
   public static void main(String [] args) throws Exception
   {
      
      if(args.length != 2)
         throw new Exception("Sposb uycia: java JmsClient_ReservationProducer <identyfikatorRejsu> <liczba>");
      
      Integer cruiseID = new Integer(args[0]);
      int count = new Integer(args[1]).intValue();
      
      Context jndiContext = getInitialContext();
      
      DataAccess access =(DataAccess)jndiContext.lookup("DataAccessBean/remote");
      access.initializeDB();
      try
      {
         access.makePaymentDbTable();
      }
      catch (Exception ignored) {}

      ConnectionFactory factory =(ConnectionFactory)jndiContext.lookup("ConnectionFactory");
      
      Queue reservationQueue =(Queue)jndiContext.lookup("queue/titan-ReservationQueue");
      Queue ticketQueue =(Queue)jndiContext.lookup("queue/titan-TicketQueue");
      
      Connection connect = factory.createConnection();      
      Session session = connect.createSession(false, Session.AUTO_ACKNOWLEDGE);
      MessageProducer sender = session.createProducer(reservationQueue);
      
      for(int i = 0; i < count; i++)
      {         
         MapMessage message = session.createMapMessage();
         
         message.setJMSReplyTo(ticketQueue);  // Kolejka wykorzystywana przez komponent ReservationProcessor do wysyania komunikatw zwrotnych.
         
         message.setStringProperty("MessageFormat", "Version 3.4");
         
         message.setInt("CruiseID", cruiseID);
         message.setInt("CustomerID", i%2 + 1);  // Klient z identyfikatorem rwnym 1 lub 2 (nasza baza danych zawiera tylko dwa rekordy).
         message.setInt("CabinID", i%5 + 1);  // Kajuty od 100 do 109.
         message.setDouble("Price",(double)1000 + i);
         
         // Wano karty wygasa w cigu 30 dni.
         //
         Date expDate = new Date(System.currentTimeMillis() + 30*24*60*60*1000L);
         
         message.setString("CreditCardNum", "5549861006051975");
         message.setLong("CreditCardExpDate", expDate.getTime());
         message.setString("CreditCardType", CreditCardDO.MASTER_CARD);
         
         System.out.println("Wysyanie komunikatu o rezerwacji nr "+i);
         sender.send(message);
      }
      
      connect.close();
   }
   
   public static Context getInitialContext()
      throws javax.naming.NamingException
   {
      return new InitialContext();
   }
}
