import RPi.GPIO as GPIO
import time

servo_pin = 18

# Dostosuj te wartości, aby ruch serwomotora odbywał się w pełnym zakresie
deg_0_pulse = 0.5   # W ms 
deg_180_pulse = 2.5 # W ms
f = 50.0   # 50Hz = 20 ms między impulsami

# Obliczenia związane z parametrami PWM
period = 1000 / f # 20 ms 
k = 100 / period         # Cykl roboczy (od 0 do 100) w okresie 20ms 
deg_0_duty = deg_0_pulse * k  
pulse_range = deg_180_pulse - deg_0_pulse
duty_range = pulse_range * k  

GPIO.setmode(GPIO.BCM)
GPIO.setup(servo_pin, GPIO.OUT) 
pwm = GPIO.PWM(servo_pin, f)      
pwm.start(0)

def set_angle(angle):  
    duty = deg_0_duty + (angle / 180.0) * duty_range
    pwm.ChangeDutyCycle(duty)

try:
    while True:   
        angle = input("Kąt (od 0 do 180): ")
        set_angle(angle)
finally:
    print("Operacje porządkujące")
    GPIO.cleanup()
