// Nazwa pliku: ExtremeC_examples_chapter16_3.c
// Opis: Przykład pokazujący użycie kolejki komunikatów POSIX.

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <mqueue.h>

int main(int argc, char** argv) {
  // Procedura obsługi kolejki komunikatów.
  mqd_t mq;

  struct mq_attr attr;
  attr.mq_flags = 0;
  attr.mq_maxmsg = 10;
  attr.mq_msgsize = 32;
  attr.mq_curmsgs = 0;


  int childpid = fork();
  if (childpid == -1) {
    fprintf(stderr, "Błąd podczas wywołania fork()!\n");
    exit(1);
  }
  if (childpid == 0) {
    // Proces potomny oczekuje na utworzenie kolejki przez proces nadrzędny.
    sleep(1);
    mqd_t mq = mq_open("/mq0", O_WRONLY);
    char str[] = "Witaj, tato!";
    // Proces potomny zapisuje dane do deskryptora pliku przeznaczonego do zapisywania danych.
    fprintf(stdout, "POTOMNY: Oczekiwanie przez dwie sekundy ...\n");
    sleep(2);
    fprintf(stdout, "POTOMNY: Zapisywanie danych...\n");
    mq_send(mq, str, strlen(str) + 1, 0);
    mq_close(mq);
  } else {
    mqd_t mq = mq_open("/mq0", O_RDONLY | O_CREAT, 0644, &attr);
    char buff[32];
    fprintf(stdout, "NADRZĘDNY: Odczytywanie danych z procesu potomnego...\n");
    int num_of_read_bytes = mq_receive(mq, buff, 32, NULL);
    fprintf(stdout, "NADRZĘDNY: Oto dane otrzymane z procesu potomnego: %s\n", buff);
    mq_close(mq);
    mq_unlink("/mq0");
  }
  return 0;
}
