// Nazwa pliku: ExtremeC_examples_chapter17_4.c
// Opis: Przykład pokazujący utworzenie obiektu
//              pamięci współdzielonej.

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <sys/mman.h>

#define SH_SIZE 16

int main(int argc, char** argv) {
  int shm_fd = shm_open("/shm0", O_CREAT | O_RDWR, 0600);
  if (shm_fd < 0) {
    fprintf(stderr, "BŁĄD! Nie udało się utworzyć obiektu pamięci współdzielonej: %s\n",
        strerror(errno));
    return 1;
  }
  fprintf(stdout, "Obiekt pamięci współdzielonej został utworzony z deskryptorem pliku o wartości: %d\n",
          shm_fd);
  if (ftruncate(shm_fd, SH_SIZE * sizeof(char)) < 0) {
    fprintf(stderr, "BŁĄD! Próba zmniejszenia obszaru pamięci zakończyła się niepowodzeniem: %s\n",
            strerror(errno));
    return 1;
  }
  fprintf(stdout, "Obszar pamięci został zmniejszony.\n");
  void* map = mmap(0, SH_SIZE, PROT_WRITE, MAP_SHARED, shm_fd, 0);
  if (map == MAP_FAILED) {
    fprintf(stderr, "BŁĄD! Mapowanie zakończyło się niepowodzeniem: %s\n",
            strerror(errno));
    return 1;
  }
  char* ptr = (char*)map;
  ptr[0] = 'A';
  ptr[1] = 'B';
  ptr[2] = 'C';
  ptr[3] = '\n';
  ptr[4] = '\0';
  while(1);
  fprintf(stdout, "Dane zostały zapisane w pamięci współdzielonej.\n");
  if (munmap(ptr, SH_SIZE) < 0) {
    fprintf(stderr, "BŁĄD! Usunięcie mapowania zakończyło się niepowodzeniem: %s\n",
            strerror(errno));
    return 1;
  }
  if (close(shm_fd) < 0) {
    fprintf(stderr, "BŁĄD! Zwolnienie pamięci współdzielonej zakończyło się niepowodzeniem: %s\n",
        strerror(errno));
    return 1;
  }
  return 0;
}
