// Nazwa pliku: ExtremeC_examples_chapter7_2_gun.c
// Opis: Implementacja klasy Gun.

#include <stdlib.h>

typedef int bool_t;

// Struktura atrybutów.
typedef struct {
  int bullets;
} gun_t;

// Alokator pamięci.
gun_t* gun_new() {
  return (gun_t*)malloc(sizeof(gun_t));
}

// Konstruktor.
void gun_ctor(gun_t* gun, int initial_bullets) {
  gun->bullets = 0;
  if (initial_bullets > 0) {
    gun->bullets = initial_bullets;
  }
}

// Destruktor.
void gun_dtor(gun_t* gun) {
  // Tutaj nie ma nic do zrobienia.
}

// Funkcje definiujące zachowanie.
bool_t gun_has_bullets(gun_t* gun) {
  return (gun->bullets > 0);
}

void gun_trigger(gun_t* gun) {
  gun->bullets--;
}

void gun_refill(gun_t* gun) {
  gun->bullets = 7;
}
