// Nazwa pliku: ExtremeC_examples_chapter5_3.c
// Opis: Przykład 5.3

#include <stdio.h>  // Ten plik nagłówkowy jest potrzebny do działania funkcji printf().
#include <stdlib.h> // Ten plik nagłówkowy jest potrzebny do działania funkcji pamięci sterty pochodzących z biblioteki C.

void print_mem_maps() {
#ifdef __linux__
  FILE* fd = fopen("/proc/self/maps", "r");
  if (!fd) {
    printf("Nie można otworzyć pliku maps.\n");
    exit(1);
  }
  char line[1024];
  while (!feof(fd)) {
    fgets(line, 1024, fd);
    printf("> %s", line);
  }
  fclose(fd);
#endif
}

int main(int argc, char** argv) {
  // Alokacja 10 bajtów bez inicjalizacji.
  char* ptr1 = (char*)malloc(10 * sizeof(char));
  printf("Adres ptr1: %p\n", (void*)&ptr1);
  printf("Pamięć zaalokowana przez funkcję malloc() w %p: ", (void*)ptr1);
  for (int i = 0; i < 10; i++) {
    printf("0x%02x ", (unsigned char)ptr1[i]);
  }
  printf("\n");

  // Alokacja 10 bajtów, wszystkie zainicjalizowane z wartością zero
  char* ptr2 = (char*)calloc(10, sizeof(char));
  printf("Adres ptr2: %p\n", (void*)&ptr2);
  printf("Pamięć zaalokowana przez funkcję calloc() w %p: ", (void*)ptr2);
  for (int i = 0; i < 10; i++) {
    printf("0x%02x ", (unsigned char)ptr2[i]);
  }
  printf("\n");

  print_mem_maps();

  free(ptr1);
  free(ptr2);

  return 0;
}
