// Nazwa pliku: ExtremeC_examples_chapter8_4_duck.c
// Opis: Implementacja prywatna klasy Duck.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ExtremeC_examples_chapter8_4_animal.h"
#include "ExtremeC_examples_chapter8_4_animal_p.h"

typedef struct {
  animal_t animal;
} duck_t;

// Definicja nowej funkcji zachowania __duck_sound().
void __duck_sound(void* ptr) {
  animal_t* animal = (animal_t*)ptr;
  printf("%s: Kwakwa\n", animal->name);
}

// Alokator pamięci.
duck_t* duck_new() {
  return (duck_t*)malloc(sizeof(duck_t));
}

// Konstruktor.
void duck_ctor(duck_t* duck) {
  animal_ctor((struct animal_t*)duck);
  strcpy(duck->animal.name, "Duck");
  // Prowadzi do nowej funkcji zachowania. Nadpisanie
  // faktycznie odbywa się w tym miejscu.
  duck->animal.sound_func = __duck_sound; 
}

// Destruktor.
void duck_dtor(duck_t* duck) {
  animal_dtor((struct animal_t*)duck);
}
