// Nazwa pliku: ExtremeC_examples_chapter7_1_car.c
// Opis: Implementacja klasy Car.

#include <stdlib.h>

// Klasa Car może pracować jedynie z interfejsem publicznym Engine.
#include "ExtremeC_examples_chapter7_1_engine.h"

typedef struct {
  // Kompozycja jest możliwa dzięki istnieniu tego atrybutu.
  struct engine_t* engine;
} car_t;

car_t* car_new() {
  return (car_t*)malloc(sizeof(car_t));
}

void car_ctor(car_t* car) {
  // Alokacja pamięci dla obiektu silnika.
  car->engine = engine_new();

  // Utworzenie obiektu silnika.
  engine_ctor(car->engine);
}

void car_dtor(car_t* car) {
  // Usunięcie obiektu silnika.
  engine_dtor(car->engine);

  // Zwolnienie pamięci zaalokowanej dla obiektu silnika.
  free(car->engine);
}

void car_start(car_t* car) {
  engine_turn_on(car->engine);
}

void car_stop(car_t* car) {
  engine_turn_off(car->engine);
}

double car_get_engine_temperature(car_t* car) {
  return engine_get_temperature(car->engine);
}
