// Nazwa pliku: ExtremeC_examples_chapter6_3.h
// Opis: Plik nagłówkowy zawierający publiczne atrybuty
//              i funkcje definiujące zachowanie, powiązane z obiektem listy.
//              Jak możesz zobaczyć, struktura atrybutów nie
//              ujawnia żadnych elementów składowych.

#ifndef EXTREME_C_EXAMPLES_CHAPTER_6_3_H
#define EXTREME_C_EXAMPLES_CHAPTER_6_3_H

#include <unistd.h>

// Struktura atrybutów nieujawniająca atrybutów.
struct list_t;

// Funkcja alokacji pamięci.
struct list_t* list_malloc();

// Funkcje konstruktora i destruktora.
void list_init(struct list_t*);
void list_destroy(struct list_t*);

// Publiczne funkcje definiujące zachowanie.
int list_add(struct list_t*, int);
int list_get(struct list_t*, int, int*);
void list_clear(struct list_t*);
size_t list_size(struct list_t*);
void list_print(struct list_t*);

#endif
