// Nazwa pliku: ExtremeC_examples_chapter10_3.c
// Opis: Ten przykład powoduje utworzenie dwóch wątków, które
//              w jednocześnie próbują odczytać i zmodyfikować
//              pojedynczą zmienną współdzieloną.

#include <stdio.h>
#include <stdlib.h>

// Nagłówek standardu POSIX niezbędny podczas pracy z biblioteką pthread.
#include <pthread.h>

void* thread_body_1(void* arg) {
  // Pobranie wskaźnika prowadzącego do zmiennej współdzielonej.
  int* shared_var_ptr = (int*)arg;
  // Inkrementacja o 1 wartości zmiennej współdzielonej
  // przez bezpośredni zapis wartości pod adresem w pamięci.
  (*shared_var_ptr)++;
  printf("%d\n", *shared_var_ptr);
  return NULL;
}

void* thread_body_2(void* arg) {
  // Pobranie wskaźnika prowadzącego do zmiennej współdzielonej.
  int* shared_var_ptr = (int*)arg;
  // Inkrementacja o 2 wartości zmiennej współdzielonej
  // przez bezpośredni zapis wartości pod adresem w pamięci.
  *shared_var_ptr += 2;
  printf("%d\n", *shared_var_ptr);
  return NULL;
}

int main(int argc, char** argv) {

  // Zmienna współdzielona.
  int shared_var = 0;

  // Uchwyty wątków.
  pthread_t thread1;
  pthread_t thread2;

  // Utworzenie nowych wątków.
  int result1 = pthread_create(&thread1, NULL,
          thread_body_1, &shared_var);
  int result2 = pthread_create(&thread2, NULL,
          thread_body_2, &shared_var);

  if (result1 || result2) {
    printf("Nie udało się utworzyć wątków.\n");
    exit(1);
  }

  // Oczekiwanie na zakończenie działania wątków.
  result1 = pthread_join(thread1, NULL);
  result2 = pthread_join(thread2, NULL);

  if (result1 || result2) {
    printf("Nie udało się dołączyć wątków.\n");
    exit(2);
  }
  return 0;
}
