// Nazwa pliku: ExtremeC_examples_chapter8_3_student.c
// Opis: Implementacja prywatna klkasy Student.

#include <stdlib.h>
#include <string.h>

// Interfejs publiczny klasy Person.
#include "ExtremeC_examples_chapter8_3_person.h"

//Deklaracja wyprzedzająca.
typedef struct {
  char* student_number;
  unsigned int passed_credits;
  // W tym miejscu jest potrzebny wskaźnik,
  // ponieważ typ person_t jest niekompletny.
  struct person_t* person;
} student_t;

// Alokator pamięci.
student_t* student_new() {
  return (student_t*)malloc(sizeof(student_t));
}

// Konstruktor.
void student_ctor(student_t* student,
                  const char* first_name,
                  const char* last_name,
                  unsigned int birth_year,
                  const char* student_number,
                  unsigned int passed_credits) {
  // Alokacja pamięci dla obiektu nadrzędnego.
  student->person = person_new();
  person_ctor(student->person, first_name,
          last_name, birth_year);
  student->student_number = (char*)malloc(16 * sizeof(char));
  strcpy(student->student_number, student_number);
  student->passed_credits = passed_credits;
}

// Destruktor.
void student_dtor(student_t* student) {
  // Najpierw trzeba usunąć obiekt potomny..
  free(student->student_number);
  // Następnie należy wywołać funkcję destruktora
  // klasy nadrzędnej.
  person_dtor(student->person);
  // Trzeba również zwolnić pamięć zaalokowaną dla obiektu nadrzędnego.
  free(student->person);
}

// Funkcje definiujące zachowanie.
void student_get_first_name(student_t* student, char* buffer) {
  // Trzeba użyć funkcji zachowania zdefiniowanej w klasie person.
  person_get_first_name(student->person, buffer);
}

void student_get_last_name(student_t* student, char* buffer) {
  // Trzeba użyć funkcji zachowania zdefiniowanej w klasie person.
  person_get_last_name(student->person, buffer);
}

unsigned int student_get_birth_year(student_t* student) {
  // Trzeba użyć funkcji zachowania zdefiniowanej w klasie person.
  return person_get_birth_year(student->person);
}

void student_get_student_number(student_t* student,
                                char* buffer) {
  strcpy(buffer, student->student_number);
}

unsigned int student_get_passed_credits(student_t* student) {
  return student->passed_credits;
}
