// Nazwa pliku: ExtremeC_examples_chapter4_4_engine.c
// Opis: Implementacja klasy Engine.

#include <stdlib.h>

typedef enum {
  ON,
  OFF
} state_t;

typedef struct {
  state_t state;
  double temperature;
} engine_t;

// Alokator pamięci.
engine_t* engine_new() {
  return (engine_t*)malloc(sizeof(engine_t));
}

// Konstruktor.
void engine_ctor(engine_t* engine) {
  engine->state = OFF;
  engine->temperature = 15;
}

// Destruktor.
void engine_dtor(engine_t* engine) {
  // Tutaj nie ma nic do zrobienia.
}

// Funkcje definiujące zachowanie.
void engine_turn_on(engine_t* engine) {
  if (engine->state == ON) {
    return;
  }
  engine->state = ON;
  engine->temperature = 75;
}

void engine_turn_off(engine_t* engine) {
  if (engine->state == OFF) {
    return;
  }
  engine->state = OFF;
  engine->temperature = 15;
}

double engine_get_temperature(engine_t* engine) {
  return engine->temperature;
}
