#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
try:
    import unittest
    
    class MyTestCase(unittest.TestCase):
        def test_equal(self):
            n = 5
            d = 3
            self.assertEqual(1.667, n / d)  # Zgłoszenie wyjątku
    
    suite = unittest.defaultTestLoader.loadTestsFromTestCase(MyTestCase)
    suite.debug()
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 2")
print(5 / 3 * 0.1)
print(0.1 * 5 / 3)


print("Przykład 3")
class MyTestCase2(unittest.TestCase):
    def test_equal(self):
        n = 5
        d = 3
        self.assertAlmostEqual(1.667, n / d, places=2)  # Zmiana

suite = unittest.defaultTestLoader.loadTestsFromTestCase(MyTestCase2)
unittest.TextTestRunner(stream=STDOUT).run(suite)


print("Przykład 4")
print(1e24 / 1.1e16)
print(1e24 / 1.101e16)


print("Przykład 5")
class MyTestCase3(unittest.TestCase):
    def test_equal(self):
        a = 1e24 / 1.1e16
        b = 1e24 / 1.101e16
        self.assertAlmostEqual(90.9e6, a, delta=0.1e6)
        self.assertAlmostEqual(90.9e6, b, delta=0.1e6)
suite = unittest.defaultTestLoader.loadTestsFromTestCase(MyTestCase3)
unittest.TextTestRunner(stream=STDOUT).run(suite)
