#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
connection = ...

class RpcError(Exception):
    pass

def lookup_request(connection):
    raise RpcError("Z metody lookup_request")

def close_connection(connection):
    print("Połączenie zostało zakończone")

try:
    request = lookup_request(connection)
except RpcError:
    print("Wystąpił błąd!")
    close_connection(connection)


print("Przykład 2")
def lookup_request(connection):
    # Nie został zgłoszony błąd
    return object()

def is_cached(connection, request):
    raise RpcError("Z metody is_cached")

try:
    request = lookup_request(connection)
    if is_cached(connection, request):
        request = None
except RpcError:
    print("Wystąpił błąd!")
    close_connection(connection)


print("Przykład 3")
def is_closed(_):
    pass

if is_closed(connection):
    # Czy połączenie zostało zakończone z powodu błędu
    # w wywołaniu metody lookup_request(), czy może is_cached()?
    pass


print("Przykład 4")
try:
    try:
        request = lookup_request(connection)
    except RpcError:
        close_connection(connection)
    else:
        if is_cached(connection, request):  # Przeniesiono
            request = None
except:
    logging.exception('Oczekiwane')
else:
    assert False
