#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
def trace(func):
    def wrapper(*args, **kwargs):
        args_repr = repr(args)
        kwargs_repr = repr(kwargs)
        result = func(*args, **kwargs)
        print(f"{func.__name__}"
              f"({args_repr}, {kwargs_repr}) "
              f"-> {result!r}")
        return result

    return wrapper


print("Przykład 2")
@trace
def fibonacci(n):
    """Wartość zwrotna to n-ta liczba ciągu Fibonacciego"""
    if n in (0, 1):
        return n
    return fibonacci(n - 2) + fibonacci(n - 1)


print("Przykład 3")
def fibonacci(n):
    """Wartość zwrotna to n-ta liczba ciągu Fibonacciego"""
    if n in (0, 1):
        return n
    return fibonacci(n - 2) + fibonacci(n - 1)

fibonacci = trace(fibonacci)


print("Przykład 4")
fibonacci(4)


print("Przykład 5")
print(fibonacci)


print("Przykład 6")
help(fibonacci)


print("Przykład 7")
try:
    import pickle
    
    pickle.dumps(fibonacci)
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 8")
from functools import wraps

def trace(func):
    @wraps(func)  # Zmiana
    def wrapper(*args, **kwargs):
        args_repr = repr(args)
        kwargs_repr = repr(kwargs)
        result = func(*args, **kwargs)
        print(f"{func.__name__}"
              f"({args_repr}, {kwargs_repr}) "
              f"-> {result!r}")
        return result

    return wrapper

@trace
def fibonacci(n):
    """Wartość zwrotna to n-ta liczba ciągu Fibonacciego"""
    if n in (0, 1):
        return n
    return fibonacci(n - 2) + fibonacci(n - 1)


print("Przykład 9")
help(fibonacci)


print("Przykład 10")
print(pickle.dumps(fibonacci))
