#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
try:
    search_key = "czerwony"
    my_dict = {"czerwony": 1, "niebieski": 2, "zielony": 3}
    
    for key in my_dict:
        if key == "niebieski":
            my_dict["żółty"] = 4  # Powoduje zgłoszenie błędu
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 2")
try:
    my_dict = {"czerwony": 1, "niebieski": 2, "zielony": 3}
    for key in my_dict:
        if key == "niebieski":
            del my_dict["zielony"]  # Powoduje zgłoszenie błędu
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 3")
my_dict = {"czerwony": 1, "niebieski": 2, "zielony": 3}
for key in my_dict:
    if key == "niebieski":
        my_dict["zielony"] = 4  # Poprawnie
print(my_dict)


print("Przykład 4")
try:
    my_set = {"czerwony", "niebieski", "zielony"}
    
    for color in my_set:
        if color == "niebieski":
            my_set.add("żółty")  # Powoduje zgłoszenie błędu
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 5")
my_set = {"czerwony", "niebieski", "zielony"}
for color in my_set:
    if color == "niebieski":
        my_set.add("zielony")  # Poprawnie

print(my_set)


print("Przykład 6")
my_list = [1, 2, 3]

for number in my_list:
    print(number)
    if number == 2:
        my_list[0] = -1  # Poprawnie

print(my_list)


print("Przykład 7")
my_list = [1, 2, 3]
bad_count = 0

for number in my_list:
    print(number)
    if number == 2:
        my_list.insert(0, 4)  # Powoduje zgłoszenie błędu
    # Zakończenie pętli działającej w nieskończoność
    bad_count += 1
    if bad_count > 5:
        print("...")
        break


print("Przykład 8")
my_list = [1, 2, 3]

for number in my_list:
    print(number)
    if number == 2:
        my_list.append(4)  # Tym razem to jest poprawne

print(my_list)


print("Przykład 9")
my_dict = {"czerwony": 1, "niebieski": 2, "zielony": 3}

keys_copy = list(my_dict.keys())  # Utworzenie kopii
for key in keys_copy:             # Iteracja przez kopię
    if key == "niebieski":
        my_dict["zielony"] = 4      # Modyfikacja pierwotnego słownika

print(my_dict)


print("Przykład 10")
my_list = [1, 2, 3]

list_copy = list(my_list)     # Utworzenie kopii
for number in list_copy:      # Iteracja przez kopię
    print(number)
    if number == 2:
        my_list.insert(0, 4)  # Wstawienie elementu na pierwotnej liście

print(my_list)


print("Przykład 11")
my_set = {"czerwony", "niebieski", "zielony"}

set_copy = set(my_set)        # Utworzenie kopii
for color in set_copy:        # Iteracja przez kopię
    if color == "niebieski":
        my_set.add("żółty")  # Dodanie elementu do pierwotnego zbioru

print(my_set)


print("Przykład 12")
my_dict = {"czerwony": 1, "niebieski": 2, "zielony": 3}
modifications = {}

for key in my_dict:
    if key == "niebieski":
        modifications["zielony"] = 4  # Dodanie do słownika roboczego

my_dict.update(modifications)       # Scalenie modyfikacji
print(my_dict)


print("Przykład 13")
my_dict = {"czerwony": 1, "niebieski": 2, "zielony": 3}
modifications = {}

for key in my_dict:
    if key == "niebieski":
        modifications["zielony"] = 4
    value = my_dict[key]
    if value == 4:                   # Ten warunek nigdy nie zostanie spełniony
        modifications["żółty"] = 5

my_dict.update(modifications)        # Scalenie modyfikacji
print(my_dict)


print("Przykład 14")
my_dict = {"czerwony": 1, "niebieski": 2, "zielony": 3}
modifications = {}

for key in my_dict:
    if key == "niebieski":
        modifications["zielony"] = 4
    value = my_dict[key]
    other_value = modifications.get(key)  # Sprawdzenie pamięci podręcznej
    if value == 4 or other_value == 4:
        modifications["żółty"] = 5

my_dict.update(modifications)             # Scalenie modyfikacji
print(my_dict)
