#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
no_snack = ()
snack = ("chipsy",)


print("Przykład 2")
snack_calories = {
    "chipsy": 140,
    "popcorn": 80,
    "orzeszki": 190,
}
items = list(snack_calories.items())
print(items)


print("Przykład 3")
item = ("Masło orzechowe", "dżem")
first_item = item[0]   # Indeks
first_half = item[:1]  # Wycinek
print(first_item)
print(first_half)


print("Przykład 4")
try:
    pair = ("Czekolada", "Masło orzechowe")
    pair[0] = "Miód"
except:
    logging.exception('Oczekiwane')
else:
    assert False


print("Przykład 5")
item = ("Masło orzechowe", "dżem")
first, second = item  # Rozpakowanie
print(first, "i", second)


print("Przykład 6")
favorite_snacks = {
    "słona": ("precle", 100),
    "słodka": ("ciasteczka", 180),
    "warzywna": ("marchewki", 20),
}
((type1, (name1, cals1)),
 (type2, (name2, cals2)),
 (type3, (name3, cals3))) = favorite_snacks.items()

print(f"Ulubiona przekąska {type1} to {name1} o {cals1} kaloriach")
print(f"Ulubiona przekąska {type2} to {name2} o {cals2} kaloriach")
print(f"Ulubiona przekąska {type3} to {name3} o {cals3} kaloriach")


print("Przykład 7")
def bubble_sort(a):
    for _ in range(len(a)):
        for i in range(1, len(a)):
            if a[i] < a[i - 1]:
                temp = a[i]
                a[i] = a[i - 1]
                a[i - 1] = temp

names = ["precle", "marchewki", "rukola", "bekon"]
bubble_sort(names)
print(names)


print("Przykład 8")
def bubble_sort(a):
    for _ in range(len(a)):
        for i in range(1, len(a)):
            if a[i] < a[i - 1]:
                a[i - 1], a[i] = a[i], a[i - 1]  # Zamiana wartości miejscami

names = ["precle", "marchewki", "rukola", "bekon"]
bubble_sort(names)
print(names)


print("Przykład 9")
snacks = [("bekon", 350), ("pączek", 240), ("babeczka", 190)]
for i in range(len(snacks)):
    item = snacks[i]
    name = item[0]
    calories = item[1]
    print(f"#{i+1}: {name} ma {calories} kalorii")


print("Przykład 10")
for rank, (name, calories) in enumerate(snacks, 1):
    print(f"#{rank}: {name} ma {calories} kalorii")
