#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 2")
baby_names = {
    "kot": "mruczek",
    "pies": "pimpek",
}
print(baby_names)


print("Przykład 4")
print(list(baby_names.keys()))
print(list(baby_names.values()))
print(list(baby_names.items()))
print(baby_names.popitem())  # Ostatni wstawiony element


print("Przykład 6")
def my_func(**kwargs):
    for key, value in kwargs.items():
        print(f"{key} = {value}")

my_func(gęś="gąska", kangur="kangurek")


print("Przykład 8")
class MyClass:
    def __init__(self):
        self.alligator = "aligator"
        self.elephant = "słoń"

a = MyClass()
for key, value in a.__dict__.items():
    print(f"{key} = {value}")


print("Przykład 9")
votes = {
    "wydra": 1281,
    "miś polarny": 587,
    "lis": 863,
}


print("Przykład 10")
def populate_ranks(votes, ranks):
    names = list(votes.keys())
    names.sort(key=votes.get, reverse=True)
    for i, name in enumerate(names, 1):
        ranks[name] = i


print("Przykład 11")
def get_winner(ranks):
    return next(iter(ranks))


print("Przykład 12")
ranks = {}
populate_ranks(votes, ranks)
print(ranks)
winner = get_winner(ranks)
print(winner)


print("Przykład 13")
from collections.abc import MutableMapping

class SortedDict(MutableMapping):
    def __init__(self):
        self.data = {}

    def __getitem__(self, key):
        return self.data[key]

    def __setitem__(self, key, value):
        self.data[key] = value

    def __delitem__(self, key):
        del self.data[key]

    def __iter__(self):
        keys = list(self.data.keys())
        keys.sort()
        for key in keys:
            yield key

    def __len__(self):
        return len(self.data)


my_dict = SortedDict()
my_dict["wydra"] = 1
my_dict["cheeta"] = 2
my_dict["mrówkojad"] = 3
my_dict["jeleń"] = 4

assert my_dict["wydra"] == 1

assert "cheeta" in my_dict
del my_dict["cheeta"]
assert "cheeta" not in my_dict

expected = [("mrówkojad", 3), ("jeleń", 4), ("wydra", 1)]
assert list(my_dict.items()) == expected

assert not isinstance(my_dict, dict)


print("Przykład 14")
sorted_ranks = SortedDict()
populate_ranks(votes, sorted_ranks)
print(sorted_ranks.data)
winner = get_winner(sorted_ranks)
print(winner)


print("Przykład 15")
def get_winner(ranks):
    for name, rank in ranks.items():
        if rank == 1:
            return name

winner = get_winner(sorted_ranks)
print(winner)


print("Przykład 16")
try:
    def get_winner(ranks):
        if not isinstance(ranks, dict):
            raise TypeError("wymagane jest użycie typu dict")
        return next(iter(ranks))
    
    
    assert get_winner(ranks) == "wydra"
    
    get_winner(sorted_ranks)
except:
    logging.exception('Oczekiwane')
else:
    assert False
